/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

public class BooleanAveragingBuffer {
    private boolean[] mBuffer;
    private int mBufferPointer;
    private int mThreshold;
    private int mTrueCount;

    public BooleanAveragingBuffer(int length) {
        this.mBuffer = new boolean[length];
        this.mThreshold = length / 2;
    }

    public boolean get(boolean newValue) {
        boolean retVal = this.mBuffer[this.mBufferPointer];
        this.put(newValue);
        return retVal;
    }

    private void put(boolean newValue) {
        this.mBuffer[this.mBufferPointer] = newValue;
        ++this.mBufferPointer;
        this.mBufferPointer %= this.mBuffer.length;
    }

    public boolean getAverage(boolean newValue) {
        this.put(newValue);
        this.mTrueCount = 0;
        for (boolean b : this.mBuffer) {
            if (!b) continue;
            ++this.mTrueCount;
        }
        return this.mTrueCount > this.mThreshold;
    }
}

