/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.bits;

import org.apache.commons.math3.util.FastMath;

public class SyncPatternMatcher {
    private long mBits = 0L;
    private long mMask = 0L;
    private long mSync = 0L;
    private boolean mSoftMode = false;
    private int mSoftModeErrorThreshold = 0;

    public SyncPatternMatcher(boolean[] syncPattern) {
        this.mMask = (long)(FastMath.pow((double)2.0, (int)syncPattern.length) - 1.0);
        for (int x = 0; x < syncPattern.length; ++x) {
            if (!syncPattern[x]) continue;
            this.mSync += 1L << syncPattern.length - 1 - x;
        }
    }

    public SyncPatternMatcher(long sync) {
        this.mSync = sync;
        this.mMask = SyncPatternMatcher.getMask(sync);
    }

    public SyncPatternMatcher(long sync, int softModeErrorThreshold) {
        this(sync);
        this.mSoftModeErrorThreshold = softModeErrorThreshold;
    }

    private static long getMask(long sync) {
        long mask = sync;
        for (int x = 1; x < 64; x *= 2) {
            mask |= mask >> x;
        }
        return mask;
    }

    public void receive(boolean bit) {
        this.mBits = Long.rotateLeft(this.mBits, 1);
        this.mBits &= this.mMask;
        if (bit) {
            ++this.mBits;
        }
    }

    public boolean matches() {
        if (this.mSoftMode) {
            long difference = this.mBits ^ this.mSync;
            return difference == 0L || Long.bitCount(difference) <= this.mSoftModeErrorThreshold;
        }
        return this.mBits == this.mSync;
    }

    public void setSoftMode(boolean softMode) {
        this.mSoftMode = softMode;
    }
}

