/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.bits;

import io.github.dsheirer.bits.ISyncProcessor;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import org.apache.commons.lang3.Validate;

public class SoftSyncDetector
implements ISyncProcessor {
    private ISyncDetectListener mListener;
    private long mPattern;
    private int mThreshold;
    private int mBitErrorCount;

    public SoftSyncDetector(long pattern, int threshold, ISyncDetectListener listener) {
        Validate.notNull((Object)listener, (String)"Sync detect listener cannot be null", (Object[])new Object[0]);
        this.mListener = listener;
        this.mPattern = pattern;
        this.mThreshold = threshold;
    }

    public SoftSyncDetector(long pattern, int threshold) {
        this.mPattern = pattern;
        this.mThreshold = threshold;
    }

    public void dispose() {
        this.mListener = null;
    }

    @Override
    public boolean checkSync(long value) {
        long difference = value ^ this.mPattern;
        if (difference == 0L) {
            this.mListener.syncDetected(0);
            return true;
        }
        this.mBitErrorCount = Long.bitCount(difference);
        if (this.mBitErrorCount <= this.mThreshold) {
            this.mListener.syncDetected(this.mBitErrorCount);
            return true;
        }
        return false;
    }

    public void setThreshold(int threshold) {
        this.mThreshold = threshold;
    }

    public void setListener(ISyncDetectListener listener) {
        this.mListener = listener;
    }
}

