/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.bits;

import io.github.dsheirer.bits.ISyncProcessor;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSyncPatternMatcher {
    private static final Logger mLog = LoggerFactory.getLogger(MultiSyncPatternMatcher.class);
    private ISyncDetectListener mSyncDetectListener;
    private int mSyncLossThreshold;
    private int mBitCount;
    private List<ISyncProcessor> mSyncProcessors = new ArrayList<ISyncProcessor>();
    private long mBits = 0L;
    private long mMask = 0L;

    public MultiSyncPatternMatcher(ISyncDetectListener syncDetectListener, int syncLossThreshold, int syncSize) {
        this.mSyncDetectListener = syncDetectListener;
        this.mSyncLossThreshold = syncLossThreshold;
        Validate.isTrue((syncSize < 64 ? 1 : 0) != 0);
        this.mMask = (long)(FastMath.pow((double)2.0, (int)syncSize) - 1.0);
    }

    public void dispose() {
        this.mSyncProcessors.clear();
    }

    public void receive(boolean bit1, boolean bit2) {
        this.mBits = Long.rotateLeft(this.mBits, 1);
        this.mBits &= this.mMask;
        if (bit1) {
            ++this.mBits;
        }
        this.mBits = Long.rotateLeft(this.mBits, 1);
        this.mBits &= this.mMask;
        if (bit2) {
            ++this.mBits;
        }
        this.mBitCount += 2;
        for (ISyncProcessor processor : this.mSyncProcessors) {
            if (!processor.checkSync(this.mBits)) continue;
            this.mBitCount = 0;
        }
        if (this.mBitCount > this.mSyncLossThreshold) {
            this.mSyncDetectListener.syncLost(this.mBitCount);
            this.mBitCount = 0;
        }
    }

    public long getCurrentValue() {
        return this.mBits;
    }

    public void receive(boolean bit) {
        this.mBits = Long.rotateLeft(this.mBits, 1);
        this.mBits &= this.mMask;
        if (bit) {
            ++this.mBits;
        }
        for (ISyncProcessor processor : this.mSyncProcessors) {
            processor.checkSync(this.mBits);
        }
    }

    public void add(ISyncProcessor processor) {
        this.mSyncProcessors.add(processor);
    }
}

