/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.bits;

import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.bits.IBinarySymbolProcessor;
import io.github.dsheirer.bits.SyncPatternMatcher;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.dsp.symbol.SyncDetectProvider;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessageFramer
implements IBinarySymbolProcessor,
Listener<Boolean>,
SyncDetectProvider {
    private boolean[] mSyncPattern;
    private int mMessageLength;
    private ISyncDetectListener mSyncDetectListener;
    private Broadcaster<CorrectedBinaryMessage> mBroadcaster = new Broadcaster();
    private List<MessageAssembler> mMessageAssemblers = new ArrayList<MessageAssembler>();
    private List<MessageAssembler> mCompletedMessageAssemblers = new ArrayList<MessageAssembler>();
    private SyncPatternMatcher mMatcher;

    public MessageFramer(boolean[] syncPattern, int messageLength) {
        this.mSyncPattern = syncPattern;
        this.mMatcher = new SyncPatternMatcher(syncPattern);
        this.mMessageLength = messageLength;
    }

    public void reset() {
        for (MessageAssembler assembler : this.mMessageAssemblers) {
            assembler.dispose();
        }
        this.mMessageAssemblers.clear();
    }

    public void dispose() {
        this.mBroadcaster.dispose();
        this.mCompletedMessageAssemblers.clear();
    }

    @Override
    public void process(boolean bit) {
        this.mMatcher.receive(bit);
        Iterator<MessageAssembler> it = this.mMessageAssemblers.iterator();
        while (it.hasNext()) {
            MessageAssembler assembler = it.next();
            if (assembler.complete()) {
                assembler.dispose();
                it.remove();
                continue;
            }
            assembler.receive(bit);
        }
        if (this.mMatcher.matches()) {
            this.addMessageAssembler(new MessageAssembler(this.mMessageLength, this.mSyncPattern));
            if (this.mSyncDetectListener != null) {
                this.mSyncDetectListener.syncDetected(0);
            }
        }
    }

    @Override
    @Deprecated
    public void receive(Boolean bit) {
        this.process(bit);
    }

    @Override
    public void setSyncDetectListener(ISyncDetectListener listener) {
        this.mSyncDetectListener = listener;
    }

    public void addMessageListener(Listener<CorrectedBinaryMessage> listener) {
        this.mBroadcaster.addListener(listener);
    }

    public void removeMessageListener(Listener<CorrectedBinaryMessage> listener) {
        this.mBroadcaster.removeListener(listener);
    }

    private void addMessageAssembler(MessageAssembler assembler) {
        this.mMessageAssemblers.add(assembler);
    }

    private void removeMessageAssembler(MessageAssembler assembler) {
        this.mMessageAssemblers.remove(assembler);
    }

    private class MessageAssembler
    implements Listener<Boolean> {
        CorrectedBinaryMessage mMessage;
        boolean mComplete = false;

        MessageAssembler(int messageLength) {
            this.mMessage = new CorrectedBinaryMessage(messageLength);
        }

        MessageAssembler(int messageLength, boolean[] initialFill) {
            this(messageLength);
            for (boolean b : initialFill) {
                this.receive(b);
            }
        }

        public void dispose() {
            this.mMessage = null;
        }

        @Override
        public void receive(Boolean bit) {
            try {
                this.mMessage.add(bit);
            }
            catch (BitSetFullException e) {
                e.printStackTrace();
            }
            if (this.mMessage.isFull()) {
                this.mComplete = true;
                this.flush();
            }
        }

        public void flush() {
            MessageFramer.this.mBroadcaster.receive(this.mMessage);
            this.mComplete = true;
        }

        public boolean complete() {
            return this.mComplete;
        }
    }
}

