/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.playback;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.audio.AudioEvent;
import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.controller.NamingThreadFactory;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.mixer.MixerChannel;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AudioOutput
implements LineListener,
Listener<IdentifierUpdateNotification> {
    private static final Logger mLog = LoggerFactory.getLogger(AudioOutput.class);
    private int mBufferStartThreshold;
    private int mBufferStopThreshold;
    private Listener<IdentifierCollection> mIdentifierCollectionListener;
    private Broadcaster<AudioEvent> mAudioEventBroadcaster;
    private SourceDataLine mOutput;
    private Mixer mMixer;
    private MixerChannel mMixerChannel;
    private FloatControl mGainControl;
    private BooleanControl mMuteControl;
    private AudioEvent mAudioStartEvent;
    private AudioEvent mAudioStopEvent;
    private boolean mCanProcessAudio;
    private LinkedTransferQueue<AudioSegment> mAudioSegmentQueue;
    private AudioSegment mCurrentAudioSegment;
    private int mCurrentBufferIndex;
    private UserPreferences mUserPreferences;
    private ByteBuffer mAudioSegmentStartTone;
    private ByteBuffer mAudioSegmentDropTone;
    private boolean mRunning;
    private ScheduledExecutorService mScheduledExecutorService;
    private ScheduledFuture<?> mProcessorFuture;
    private boolean mDropDuplicates;
    private long mOutputLastTimestamp;
    private static final long STALE_PLAYBACK_THRESHOLD_MS = 500L;

    public AudioOutput(Mixer mixer, MixerChannel mixerChannel, AudioFormat audioFormat, Line.Info lineInfo, int requestedBufferSize, UserPreferences userPreferences) {
        block7: {
            this.mAudioEventBroadcaster = new Broadcaster();
            this.mCanProcessAudio = false;
            this.mAudioSegmentQueue = new LinkedTransferQueue();
            this.mCurrentBufferIndex = 0;
            this.mRunning = false;
            this.mOutputLastTimestamp = 0L;
            this.mMixer = mixer;
            this.mMixerChannel = mixerChannel;
            this.mScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory("sdrtrunk audio output " + mixerChannel.name()));
            this.mUserPreferences = userPreferences;
            this.mDropDuplicates = this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicatePlaybackSuppressionEnabled();
            try {
                this.mOutput = (SourceDataLine)this.mMixer.getLine(lineInfo);
                if (this.mOutput == null) break block7;
                this.mOutput.open(audioFormat, requestedBufferSize);
                this.mBufferStartThreshold = (int)((double)this.mOutput.getBufferSize() * 0.1);
                this.mBufferStopThreshold = (int)((double)this.mOutput.getBufferSize() * 0.9);
                this.mOutput.addLineListener(this);
                if (this.mOutput != null) {
                    try {
                        Control gain = this.mOutput.getControl(FloatControl.Type.MASTER_GAIN);
                        this.mGainControl = (FloatControl)gain;
                    }
                    catch (IllegalArgumentException iae) {
                        mLog.warn("Couldn't obtain MASTER GAIN control for stereo line [" + mixer.getMixerInfo().getName() + " | " + this.getChannelName() + "]");
                    }
                    try {
                        Control mute = this.mOutput.getControl(BooleanControl.Type.MUTE);
                        this.mMuteControl = (BooleanControl)mute;
                    }
                    catch (IllegalArgumentException iae) {
                        mLog.warn("Couldn't obtain MUTE control for stereo line [" + mixer.getMixerInfo().getName() + " | " + this.getChannelName() + "]");
                    }
                    this.mProcessorFuture = this.mScheduledExecutorService.scheduleAtFixedRate(new AudioSegmentProcessor(), 0L, 100L, TimeUnit.MILLISECONDS);
                }
                this.mAudioStartEvent = new AudioEvent(AudioEvent.Type.AUDIO_STARTED, this.getChannelName());
                this.mAudioStopEvent = new AudioEvent(AudioEvent.Type.AUDIO_STOPPED, this.getChannelName());
                this.mCanProcessAudio = true;
            }
            catch (LineUnavailableException e) {
                mLog.error("Couldn't obtain audio source data line for audio output - mixer [" + this.mMixer.getMixerInfo().getName() + "]");
            }
        }
        this.updateToneInsertionAudioClips();
        MyEventBus.getGlobalEventBus().register((Object)this);
    }

    public boolean isEmpty() {
        return this.mAudioSegmentQueue.isEmpty();
    }

    public void play(AudioSegment audioSegment) {
        if (audioSegment != null) {
            this.mAudioSegmentQueue.add(audioSegment);
        }
    }

    public boolean isLinkedTo(AudioSegment audioSegment) {
        return audioSegment.isLinked() && audioSegment.isLinkedTo(this.mCurrentAudioSegment);
    }

    @Override
    public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
        IdentifierCollection identifierCollection;
        if (this.mCurrentAudioSegment != null && (identifierCollection = this.mCurrentAudioSegment.getIdentifierCollection()) != null) {
            this.broadcast(identifierCollection);
        }
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.PLAYBACK) {
            this.updateToneInsertionAudioClips();
        } else if (preferenceType == PreferenceType.DUPLICATE_CALL_DETECTION) {
            this.mDropDuplicates = this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicatePlaybackSuppressionEnabled();
        }
    }

    private void updateToneInsertionAudioClips() {
        float[] drop;
        this.mAudioSegmentStartTone = null;
        this.mAudioSegmentDropTone = null;
        float[] start = this.mUserPreferences.getPlaybackPreference().getStartTone();
        if (start != null) {
            this.mAudioSegmentStartTone = this.convert(start);
        }
        if ((drop = this.mUserPreferences.getPlaybackPreference().getDropTone()) != null) {
            this.mAudioSegmentDropTone = this.convert(drop);
        }
    }

    private void playAudio(ByteBuffer buffer) {
        if (buffer != null) {
            int wrote = 0;
            if (!this.mOutput.isRunning()) {
                int toWrite = this.mOutput.available();
                if (toWrite > buffer.array().length) {
                    toWrite = buffer.array().length;
                }
                wrote += this.mOutput.write(buffer.array(), 0, toWrite);
                this.mOutputLastTimestamp = System.currentTimeMillis();
                this.checkStart();
            }
            if (this.mOutput.isRunning() && wrote < buffer.array().length) {
                this.mOutput.write(buffer.array(), wrote, buffer.array().length - wrote);
                this.mOutputLastTimestamp = System.currentTimeMillis();
            }
        }
    }

    private void disposeCurrentAudioSegment() {
        if (this.mCurrentAudioSegment != null) {
            this.mCurrentAudioSegment.decrementConsumerCount();
            this.mCurrentAudioSegment.removeIdentifierUpdateNotificationListener(this);
            this.mCurrentAudioSegment = null;
            this.broadcast(null);
        }
    }

    private void loadNextAudioSegment() {
        boolean verificationInProgress;
        AudioSegment audioSegment = this.mAudioSegmentQueue.poll();
        boolean bl = verificationInProgress = audioSegment != null;
        while (verificationInProgress) {
            if (audioSegment != null) {
                if (this.isThrowaway(audioSegment)) {
                    audioSegment.decrementConsumerCount();
                    audioSegment = this.mAudioSegmentQueue.poll();
                    continue;
                }
                verificationInProgress = false;
                continue;
            }
            verificationInProgress = false;
        }
        this.mCurrentAudioSegment = audioSegment;
        if (audioSegment != null) {
            this.mCurrentAudioSegment.addIdentifierUpdateNotificationListener(this);
            this.broadcast(this.mCurrentAudioSegment.getIdentifierCollection());
        }
        this.mCurrentBufferIndex = 0;
    }

    private boolean isThrowaway(AudioSegment audioSegment) {
        return audioSegment != null && (audioSegment.isDoNotMonitor() || this.mDropDuplicates && audioSegment.isDuplicate());
    }

    private void processAudio() {
        if (this.mCurrentAudioSegment == null) {
            this.loadNextAudioSegment();
        }
        while (this.isThrowaway(this.mCurrentAudioSegment)) {
            if (this.mCurrentBufferIndex > 0) {
                this.playAudio(this.mAudioSegmentDropTone);
            }
            this.disposeCurrentAudioSegment();
            this.loadNextAudioSegment();
        }
        while (this.mCurrentAudioSegment != null && this.mCurrentBufferIndex < this.mCurrentAudioSegment.getAudioBufferCount()) {
            if (this.isThrowaway(this.mCurrentAudioSegment)) {
                if (this.mCurrentBufferIndex > 0) {
                    this.playAudio(this.mAudioSegmentDropTone);
                }
                this.disposeCurrentAudioSegment();
                continue;
            }
            if (this.mCurrentBufferIndex == 0) {
                this.playAudio(this.mAudioSegmentStartTone);
            }
            try {
                float[] audioBuffer = this.mCurrentAudioSegment.getAudioBuffers().get(this.mCurrentBufferIndex++);
                if (audioBuffer == null) continue;
                ByteBuffer audio = this.convert(audioBuffer);
                this.playAudio(audio);
            }
            catch (Exception e) {
                mLog.error("Error while processing audio for [" + this.mMixerChannel.name() + "]", (Throwable)e);
            }
        }
        if (this.mCurrentAudioSegment != null && this.mCurrentAudioSegment.isComplete() && this.mCurrentBufferIndex >= this.mCurrentAudioSegment.getAudioBufferCount()) {
            this.disposeCurrentAudioSegment();
        }
        this.checkStop();
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
        this.mCanProcessAudio = false;
        if (this.mProcessorFuture != null) {
            this.mProcessorFuture.cancel(true);
        }
        this.mProcessorFuture = null;
        this.disposeCurrentAudioSegment();
        this.mAudioEventBroadcaster.clear();
        this.mIdentifierCollectionListener = null;
        if (this.mOutput != null) {
            this.mOutput.close();
        }
        this.mOutput = null;
        this.mGainControl = null;
        this.mMuteControl = null;
    }

    protected abstract ByteBuffer convert(float[] var1);

    public String getChannelName() {
        return this.mMixerChannel.getLabel();
    }

    protected MixerChannel getMixerChannel() {
        return this.mMixerChannel;
    }

    public void addAudioEventListener(Listener<AudioEvent> listener) {
        this.mAudioEventBroadcaster.addListener(listener);
    }

    public void removeAudioEventListener(Listener<AudioEvent> listener) {
        this.mAudioEventBroadcaster.removeListener(listener);
    }

    private void broadcastAudioEvent(AudioEvent audioEvent) {
        this.mAudioEventBroadcaster.broadcast(audioEvent);
    }

    public void setIdentifierCollectionListener(Listener<IdentifierCollection> listener) {
        this.mIdentifierCollectionListener = listener;
    }

    public void removeAudioMetadataListener() {
        this.mIdentifierCollectionListener = null;
    }

    private void broadcast(IdentifierCollection identifierCollection) {
        if (this.mIdentifierCollectionListener != null) {
            this.mIdentifierCollectionListener.receive(identifierCollection);
        }
    }

    private void checkStart() {
        if (this.mCanProcessAudio && !this.mOutput.isRunning() && this.mOutput.available() <= this.mBufferStartThreshold) {
            this.mOutput.start();
            this.mRunning = true;
        }
    }

    private void checkStop() {
        if (this.mRunning) {
            if (this.mOutput.isRunning()) {
                if (this.mOutput.available() >= this.mBufferStopThreshold) {
                    this.mOutput.drain();
                    this.mOutput.stop();
                    this.mRunning = false;
                } else if (this.mOutput.available() < this.mBufferStopThreshold && this.mOutput.available() > this.mBufferStartThreshold && System.currentTimeMillis() - this.mOutputLastTimestamp >= 500L) {
                    this.mOutput.stop();
                    this.mOutput.flush();
                    this.mRunning = false;
                }
            } else {
                this.mRunning = false;
            }
            if (!this.mRunning) {
                this.broadcast(null);
            }
        }
    }

    public void setMuted(boolean muted) {
        if (this.mMuteControl != null) {
            this.mMuteControl.setValue(muted);
            this.broadcastAudioEvent(new AudioEvent(muted ? AudioEvent.Type.AUDIO_MUTED : AudioEvent.Type.AUDIO_UNMUTED, this.getChannelName()));
        }
    }

    public boolean isMuted() {
        if (this.mMuteControl != null) {
            return this.mMuteControl.getValue();
        }
        return false;
    }

    public FloatControl getGainControl() {
        return this.mGainControl;
    }

    public boolean hasGainControl() {
        return this.mGainControl != null;
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        if (type == LineEvent.Type.START) {
            this.mAudioEventBroadcaster.broadcast(this.mAudioStartEvent);
        } else if (type == LineEvent.Type.STOP) {
            this.mAudioEventBroadcaster.broadcast(this.mAudioStopEvent);
        }
    }

    public class AudioSegmentProcessor
    implements Runnable {
        private AtomicBoolean mProcessing = new AtomicBoolean();

        @Override
        public void run() {
            if (this.mProcessing.compareAndSet(false, true)) {
                try {
                    AudioOutput.this.processAudio();
                }
                catch (Throwable t) {
                    mLog.error("Error while processing audio buffers", t);
                }
                this.mProcessing.set(false);
            }
        }
    }
}

