/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.invert;

import io.github.dsheirer.audio.invert.AudioType;
import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.FloatFIRFilter;
import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import io.github.dsheirer.dsp.window.WindowType;

public class AudioAdapter {
    private static int mGain = 5;
    private IRealOscillator mSineWaveGenerator;
    private FloatFIRFilter mPostInversionFilter;
    private FloatFIRFilter mAudioHighPassFilter;
    private AudioType mAudioType = AudioType.NORMAL;
    private int mSampleRate;

    public AudioAdapter(int sampleRate) {
        this.mSampleRate = sampleRate;
        this.mSineWaveGenerator = OscillatorFactory.getRealOscillator(3000.0, this.mSampleRate);
        this.mAudioHighPassFilter = new FloatFIRFilter(FilterFactory.getHighPass(this.mSampleRate, 200L, 1600L, 48, WindowType.HAMMING, true), mGain);
        this.mPostInversionFilter = new FloatFIRFilter(FilterFactory.getLowPass(this.mSampleRate, 3000, 5000, 48, WindowType.HAMMING, true), mGain);
    }

    public void setAudioType(AudioType type) {
        if (type != null && type != this.mAudioType) {
            this.mAudioType = type;
            int inversionFrequency = type.getAudioInversionFrequency();
            if (inversionFrequency != 0) {
                this.mSineWaveGenerator.setFrequency(inversionFrequency);
            }
        }
    }

    public float get(float sample) {
        return switch (this.mAudioType) {
            case AudioType.NORMAL -> this.mAudioHighPassFilter.get(sample);
            case AudioType.MUTE -> 0.0f;
            default -> this.mPostInversionFilter.get(this.mAudioHighPassFilter.get(sample) * this.mSineWaveGenerator.generate(1)[0]);
        };
    }
}

