/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert.thumbdv.message.request;

import io.github.dsheirer.audio.convert.thumbdv.message.PacketField;
import io.github.dsheirer.audio.convert.thumbdv.message.request.AmbeRequest;

public class EncodeSpeechRequest
extends AmbeRequest {
    private static final int CHANNEL_IDENTIFIER_INDEX = 4;
    private static final int SPEECH_DATA_IDENTIFIER_INDEX = 5;
    private static final int SAMPLE_COUNT_INDEX = 6;
    private static final int SPEECH_DATA_START_INDEX = 7;
    private short[] mSamples;

    public EncodeSpeechRequest(short[] samples) {
        this.mSamples = samples;
    }

    public EncodeSpeechRequest(float[] samples) {
        this.mSamples = new short[samples.length];
        for (int x = 0; x < samples.length; ++x) {
            this.mSamples[x] = samples[x] > 1.0f ? Short.MAX_VALUE : (samples[x] < -1.0f ? Short.MIN_VALUE : (short)(samples[x] * 32767.0f));
        }
    }

    @Override
    public PacketField getType() {
        return PacketField.PACKET_TYPE_DECODE_SPEECH;
    }

    @Override
    public byte[] getData() {
        int length = this.mSamples.length * 2 + 3;
        byte[] data = this.createMessage(length, this.getType());
        data[4] = PacketField.PKT_CHANNEL_0.getCode();
        data[5] = 0;
        data[6] = (byte)(0xFF & this.mSamples.length);
        int pointer = 7;
        for (short sample : this.mSamples) {
            data[pointer++] = (byte)(sample >> 8 & 0xFF);
            data[pointer++] = (byte)(sample & 0xFF);
        }
        return data;
    }
}

