/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert.thumbdv.message.request;

import io.github.dsheirer.audio.convert.thumbdv.message.PacketField;
import io.github.dsheirer.audio.convert.thumbdv.message.VocoderRate;
import io.github.dsheirer.audio.convert.thumbdv.message.request.AmbeRequest;

public class DecodeSpeechRequest
extends AmbeRequest {
    private static final int CHANNEL_DATA_IDENTIFIER_INDEX = 4;
    private static final byte SAMPLE_COUNT = -96;
    private byte[] mAudioFrame;
    private VocoderRate mVocoderRate;

    public DecodeSpeechRequest(byte[] audioFrame, VocoderRate vocoderRate) {
        this.mAudioFrame = audioFrame;
        this.mVocoderRate = vocoderRate;
    }

    public DecodeSpeechRequest(byte[] audioFrame) {
        this(audioFrame, null);
    }

    @Override
    public PacketField getType() {
        return PacketField.PACKET_TYPE_ENCODE_SPEECH;
    }

    private boolean hasVocoderRate() {
        return this.mVocoderRate != null;
    }

    @Override
    public byte[] getData() {
        if (this.hasVocoderRate()) {
            int length = this.mAudioFrame.length + 9;
            byte[] data = this.createMessage(length, this.getType());
            int offset = 4;
            data[offset++] = PacketField.VOCODER.getCode();
            data[offset++] = this.mVocoderRate.getCode();
            data[offset++] = PacketField.CHANNEL_DATA_HARD_SYMBOL.getCode();
            data[offset++] = (byte)(0xFF & this.mAudioFrame.length * 8);
            System.arraycopy(this.mAudioFrame, 0, data, offset, this.mAudioFrame.length);
            offset += this.mAudioFrame.length;
            data[offset++] = PacketField.SAMPLE_COUNT.getCode();
            data[offset++] = -96;
            data[offset++] = 2;
            data[offset++] = 0;
            data[offset] = 0;
            return data;
        }
        int length = this.mAudioFrame.length + 2;
        byte[] data = this.createMessage(length, this.getType());
        int offset = 4;
        data[offset++] = PacketField.CHANNEL_DATA_HARD_SYMBOL.getCode();
        data[offset++] = (byte)(0xFF & this.mAudioFrame.length * 8);
        System.arraycopy(this.mAudioFrame, 0, data, offset, this.mAudioFrame.length);
        return data;
    }
}

