/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert.thumbdv.message;

import io.github.dsheirer.audio.convert.thumbdv.message.AmbeMessage;
import io.github.dsheirer.audio.convert.thumbdv.message.PacketField;
import io.github.dsheirer.audio.convert.thumbdv.message.response.DecodeSpeechResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.EncodeSpeechResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.GetConfigResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.InitializeCodecResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.ProductIdResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.ReadyResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.SetChannelFormatResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.SetChannelResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.SetPacketModeResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.SetSpeechFormatResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.SetVocoderParameterResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.SetVocoderResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.UnknownResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.VersionResponse;

public class AmbeMessageFactory {
    private static final byte CONTROL_PACKET = 0;
    private static final byte CHANNEL_PACKET = 1;
    private static final byte SPEECH_PACKET = 2;
    private static final int INDEX_PACKET_TYPE = 3;
    private static final int INDEX_CONTROL_PACKET_TYPE = 4;

    public static AmbeMessage getMessage(byte[] data) {
        if (data != null && data.length >= 5) {
            if (data[3] == 0) {
                PacketField packetField = PacketField.fromValue(data[4]);
                switch (packetField) {
                    case PKT_CHANNEL_0: {
                        return new SetChannelResponse(data);
                    }
                    case PKT_CHANNEL_FORMAT: {
                        return new SetChannelFormatResponse(data);
                    }
                    case PKT_CODEC_STOP: {
                        return new SetPacketModeResponse(data);
                    }
                    case PKT_GET_CONFIG: {
                        return new GetConfigResponse(data);
                    }
                    case PKT_INIT: {
                        return new InitializeCodecResponse(data);
                    }
                    case PKT_PRODUCT_ID: {
                        return new ProductIdResponse(data);
                    }
                    case PKT_RATE_PARAMETER: {
                        return new SetVocoderParameterResponse(data);
                    }
                    case PKT_RATE_TABLE: {
                        return new SetVocoderResponse(data);
                    }
                    case PKT_READY: {
                        return new ReadyResponse(data);
                    }
                    case PKT_SPEECH_FORMAT: {
                        return new SetSpeechFormatResponse(data);
                    }
                    case PKT_VERSION_STRING: {
                        return new VersionResponse(data);
                    }
                }
            } else {
                if (data[3] == 1) {
                    return new EncodeSpeechResponse(data);
                }
                if (data[3] == 2) {
                    return new DecodeSpeechResponse(data);
                }
            }
        }
        return new UnknownResponse(data);
    }
}

