/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.codec.mbe;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.codec.mbe.JmbeAudioModule;
import io.github.dsheirer.preference.UserPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImbeAudioModule
extends JmbeAudioModule {
    private static final Logger mLog = LoggerFactory.getLogger(ImbeAudioModule.class);
    private static final String IMBE_CODEC = "IMBE";
    private static boolean sLibraryStatusLogged = false;

    public ImbeAudioModule(UserPreferences userPreferences, AliasList aliasList) {
        super(userPreferences, aliasList, 0);
        if (!sLibraryStatusLogged) {
            if (this.getAudioCodec() != null) {
                mLog.info("JMBE audio conversion library IMBE CODEC successfully loaded - P25-1 audio will be available");
            } else {
                mLog.warn("JMBE audio conversion library, IMBE CODEC not loaded - P25-1 audio will NOT be available");
            }
            sLibraryStatusLogged = true;
        }
    }

    @Override
    protected String getCodecName() {
        return IMBE_CODEC;
    }
}

