/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox;

import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessage;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessageType;
import io.github.dsheirer.util.XTEA;
import java.util.Arrays;

public class AuthenticateBroadcast
extends UltravoxMessage {
    public static final String STREAM_ID_ERROR = "Stream ID Error";

    public AuthenticateBroadcast() {
        super(UltravoxMessageType.AUTHENTICATE_BROADCAST);
    }

    AuthenticateBroadcast(byte[] data) {
        super(data);
    }

    public void setCredentials(String encryptionKey, int streamID, String userID, String password) {
        XTEA xtea = new XTEA(encryptionKey);
        StringBuilder sb = new StringBuilder();
        sb.append("2.1");
        sb.append(":");
        sb.append(streamID);
        sb.append(":");
        sb.append(userID != null ? AuthenticateBroadcast.encrypt(xtea, userID) : "");
        sb.append(":");
        sb.append(password != null ? AuthenticateBroadcast.encrypt(xtea, password) : "");
        this.setPayload(sb.toString());
    }

    private static String encrypt(XTEA xtea, byte[] value) {
        if (value.length % 8 != 0 || value.length == 0) {
            int newLength = (value.length / 8 + 1) * 8;
            value = Arrays.copyOf(value, newLength);
        }
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < value.length; x += 8) {
            byte[] encrypted;
            byte[] plaintext = Arrays.copyOfRange(value, x, x + 8);
            for (byte b : encrypted = xtea.encrypt(plaintext)) {
                sb.append(String.format("%02x", b));
            }
        }
        return sb.toString();
    }

    private static String encrypt(XTEA xtea, String value) {
        return AuthenticateBroadcast.encrypt(xtea, value.getBytes());
    }
}

