/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v2;

import com.google.common.base.Joiner;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.AudioStreamingBroadcaster;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.IBroadcastMetadataUpdater;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ShoutcastV2Configuration;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.AuthenticateBroadcast;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.CacheableXMLMetadata;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.ConfigureIcyName;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.ConfigureIcyPublic;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.MP3Audio;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.NegotiateMaxPayloadSize;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.RequestCipher;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.SetupBroadcast;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.Standby;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.StreamMimeType;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessage;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessageFactory;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessageType;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMetadata;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxProtocolFactory;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.math3.util.FastMath;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShoutcastV2AudioStreamingBroadcaster
extends AudioStreamingBroadcaster
implements IBroadcastMetadataUpdater {
    private static final Logger mLog = LoggerFactory.getLogger(ShoutcastV2AudioStreamingBroadcaster.class);
    private static final long RECONNECT_INTERVAL_MILLISECONDS = 30000L;
    private int mMaxPayloadSize = 16377;
    private NioSocketConnector mSocketConnector;
    private IoSession mStreamingSession = null;
    private AliasModel mAliasModel;
    private long mLastConnectionAttempt = 0L;
    private AtomicBoolean mConnecting = new AtomicBoolean();
    private LinkedTransferQueue<UltravoxMessage> mMetadataMessageQueue = new LinkedTransferQueue();

    public ShoutcastV2AudioStreamingBroadcaster(ShoutcastV2Configuration configuration, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting, AliasModel aliasModel) {
        super(configuration, inputAudioFormat, mp3Setting);
        this.mAliasModel = aliasModel;
    }

    public ShoutcastV2Configuration getConfiguration() {
        return (ShoutcastV2Configuration)this.getBroadcastConfiguration();
    }

    @Override
    protected void broadcastAudio(byte[] audio, IdentifierCollection identifierCollection) {
        UltravoxMessage metadataMessage = this.mMetadataMessageQueue.poll();
        while (metadataMessage != null) {
            this.mStreamingSession.write((Object)metadataMessage);
            metadataMessage = this.mMetadataMessageQueue.poll();
        }
        if (audio != null && audio.length > 0 && this.connect() && this.mStreamingSession != null && this.mStreamingSession.isConnected()) {
            MP3Audio mp3Audio = new MP3Audio();
            mp3Audio.setPayload(audio);
            this.mStreamingSession.write((Object)mp3Audio);
        }
    }

    @Override
    public void update(IdentifierCollection identifierCollection) {
        List<UltravoxMessage> metadataMessages = this.getMetadataMessages(identifierCollection);
        if (!metadataMessages.isEmpty()) {
            this.mMetadataMessageQueue.addAll(metadataMessages);
        }
    }

    @Override
    protected IBroadcastMetadataUpdater getMetadataUpdater() {
        return this;
    }

    private boolean connect() {
        if (!this.connected() && this.canConnect() && this.mLastConnectionAttempt + 30000L < System.currentTimeMillis() && this.mConnecting.compareAndSet(false, true)) {
            this.mLastConnectionAttempt = System.currentTimeMillis();
            if (this.mSocketConnector == null) {
                this.mSocketConnector = new NioSocketConnector();
                this.mSocketConnector.setConnectTimeoutCheckInterval(10000L);
                this.mSocketConnector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new UltravoxProtocolFactory()));
                this.mSocketConnector.setHandler((IoHandler)new ShoutcastV2IOHandler());
            }
            this.mStreamingSession = null;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.CONNECTING);
                    try {
                        ConnectFuture future = ShoutcastV2AudioStreamingBroadcaster.this.mSocketConnector.connect((SocketAddress)new InetSocketAddress(((BroadcastConfiguration)ShoutcastV2AudioStreamingBroadcaster.this.getBroadcastConfiguration()).getHost(), ((BroadcastConfiguration)ShoutcastV2AudioStreamingBroadcaster.this.getBroadcastConfiguration()).getPort()));
                        future.awaitUninterruptibly();
                        ShoutcastV2AudioStreamingBroadcaster.this.mStreamingSession = future.getSession();
                    }
                    catch (RuntimeIoException rie) {
                        Throwable throwableCause = rie.getCause();
                        if (throwableCause instanceof ConnectException) {
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.NO_SERVER);
                        } else if (throwableCause != null) {
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                            mLog.error("Failed to connect", (Throwable)rie);
                        } else {
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                            mLog.error("Failed to connect - no exception is available");
                        }
                        ShoutcastV2AudioStreamingBroadcaster.this.disconnect();
                    }
                    catch (Throwable t) {
                        ShoutcastV2AudioStreamingBroadcaster.this.disconnect();
                    }
                    ShoutcastV2AudioStreamingBroadcaster.this.mConnecting.set(false);
                }
            };
            ThreadPool.CACHED.submit(runnable);
        }
        return this.connected();
    }

    @Override
    public void disconnect() {
        if (this.connected() && this.mStreamingSession != null) {
            this.mStreamingSession.closeNow();
        } else {
            this.mLastConnectionAttempt = System.currentTimeMillis();
        }
    }

    private List<UltravoxMessage> getMetadataMessages(IdentifierCollection identifierCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><metadata>");
        try {
            sb.append(UltravoxMetadata.ALBUM_TITLE.asXML(this.getConfiguration().getName()));
            sb.append(UltravoxMetadata.BROADCAST_CLIENT_APPLICATION.asXML(SystemProperties.getInstance().getApplicationName()));
            if (this.getConfiguration().hasGenre()) {
                sb.append(UltravoxMetadata.GENRE.asXML(this.getConfiguration().getGenre()));
            }
            if (this.getConfiguration().hasURL()) {
                sb.append(UltravoxMetadata.URL.asXML(this.getConfiguration().getURL()));
            }
            if (identifierCollection != null) {
                List<Identifier> fromIdentifiers;
                List<Identifier> toIdentifiers;
                StringBuilder sbTitle2 = new StringBuilder();
                AliasList aliasList = this.mAliasModel.getAliasList(identifierCollection);
                Identifier to = identifierCollection.getIdentifier(IdentifierClass.USER, Form.PATCH_GROUP, Role.TO);
                if (to == null) {
                    to = identifierCollection.getIdentifier(IdentifierClass.USER, Form.TALKGROUP, Role.TO);
                }
                if (to == null && !(toIdentifiers = identifierCollection.getIdentifiers(Role.TO)).isEmpty()) {
                    to = toIdentifiers.get(0);
                }
                if (to != null) {
                    sbTitle2.append("TO:").append(to);
                    List<Alias> aliases = aliasList.getAliases(to);
                    if (!aliases.isEmpty()) {
                        sbTitle2.append(" ").append(Joiner.on((String)", ").skipNulls().join(aliases));
                    }
                } else {
                    sbTitle2.append("TO:UNKNOWN");
                }
                Identifier from = identifierCollection.getIdentifier(IdentifierClass.USER, Form.RADIO, Role.FROM);
                if (from == null && !(fromIdentifiers = identifierCollection.getIdentifiers(Role.FROM)).isEmpty()) {
                    from = fromIdentifiers.get(0);
                }
                if (from != null) {
                    sbTitle2.append(" FROM:").append(from);
                    List<Alias> aliases = aliasList.getAliases(from);
                    if (!aliases.isEmpty()) {
                        sbTitle2.append(" ").append(Joiner.on((String)", ").skipNulls().join(aliases));
                    }
                } else {
                    sbTitle2.append(" FROM:UNKNOWN");
                }
                sb.append(UltravoxMetadata.TITLE_2.asXML(sbTitle2.toString()));
            } else {
                sb.append(UltravoxMetadata.TITLE_2.asXML("Scanning ..."));
            }
        }
        catch (UnsupportedEncodingException uee) {
            mLog.error("UTF-8 Encoding is not supported - shoutcast/ultravox metadata will not be updated");
        }
        sb.append("</metadata>");
        byte[] xml = sb.toString().getBytes();
        int pointer = 0;
        int messageCounter = 1;
        int messageCount = (int)FastMath.ceil((double)((double)xml.length / (double)(this.mMaxPayloadSize - 6)));
        if (messageCount > 32) {
            messageCount = 32;
        }
        ArrayList<UltravoxMessage> messages = new ArrayList<UltravoxMessage>();
        while (pointer < xml.length && messageCounter <= messageCount) {
            int payloadSize = FastMath.min((int)(this.mMaxPayloadSize - 6), (int)(xml.length - pointer));
            byte[] payload = new byte[payloadSize + 6];
            payload[1] = 1;
            payload[3] = (byte)(messageCount & 0xFF);
            payload[5] = (byte)(messageCounter & 0xFF);
            System.arraycopy(xml, pointer, payload, 6, payloadSize);
            CacheableXMLMetadata message = new CacheableXMLMetadata();
            message.setPayload(payload);
            messages.add(message);
            pointer += payloadSize;
        }
        return messages;
    }

    public class ShoutcastV2IOHandler
    extends IoHandlerAdapter {
        public void sessionOpened(IoSession session) throws Exception {
            session.write((Object)UltravoxMessageFactory.getMessage(UltravoxMessageType.REQUEST_CIPHER));
        }

        public void sessionClosed(IoSession session) throws Exception {
            ShoutcastV2AudioStreamingBroadcaster.this.mLastConnectionAttempt = System.currentTimeMillis();
            if (!ShoutcastV2AudioStreamingBroadcaster.this.getBroadcastState().isErrorState()) {
                ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
            }
            ShoutcastV2AudioStreamingBroadcaster.this.mStreamingSession = null;
            ShoutcastV2AudioStreamingBroadcaster.this.mConnecting.set(false);
            super.sessionClosed(session);
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (cause instanceof IOException) {
                IOException ioe = (IOException)cause;
                if (ioe.getMessage() != null) {
                    String reason = ioe.getMessage();
                    if (reason.startsWith("Connection reset")) {
                        mLog.info("Streaming connection reset by remote server - reestablishing connection");
                        ShoutcastV2AudioStreamingBroadcaster.this.disconnect();
                    } else if (reason.startsWith("Operation timed out")) {
                        mLog.info("Streaming connection timed out - resetting connection");
                        ShoutcastV2AudioStreamingBroadcaster.this.disconnect();
                    } else {
                        ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                        ShoutcastV2AudioStreamingBroadcaster.this.disconnect();
                        mLog.error("Unrecognized IO error: " + reason + ". Streaming halted.");
                    }
                } else {
                    ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                    ShoutcastV2AudioStreamingBroadcaster.this.disconnect();
                    mLog.error("Unspecified IO error - streaming halted.");
                }
            } else {
                mLog.error("Broadcast error", cause);
                ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                ShoutcastV2AudioStreamingBroadcaster.this.disconnect();
            }
            ShoutcastV2AudioStreamingBroadcaster.this.mConnecting.set(false);
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            if (object instanceof UltravoxMessage) {
                UltravoxMessage ultravoxMessage = (UltravoxMessage)object;
                switch (ultravoxMessage.getMessageType()) {
                    case REQUEST_CIPHER: {
                        String cipherKey = ((RequestCipher)ultravoxMessage).getCipher();
                        AuthenticateBroadcast authenticateBroadcast = new AuthenticateBroadcast();
                        authenticateBroadcast.setCredentials(cipherKey, ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getStreamID(), ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getUserID(), ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getPassword());
                        session.write((Object)authenticateBroadcast);
                        break;
                    }
                    case AUTHENTICATE_BROADCAST: {
                        if (ultravoxMessage.isErrorResponse()) {
                            String errorMessage = ultravoxMessage.getErrorMessage();
                            if (errorMessage.startsWith("Stream ID Error")) {
                                ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.INVALID_MOUNT_POINT);
                                break;
                            }
                            mLog.error("Invalid Credentials - response: " + ultravoxMessage.getPayload());
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.INVALID_CREDENTIALS);
                            break;
                        }
                        StreamMimeType streamMimeType = new StreamMimeType();
                        streamMimeType.setFormat(ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getBroadcastFormat());
                        session.write((Object)streamMimeType);
                        break;
                    }
                    case STREAM_MIME_TYPE: {
                        if (ultravoxMessage.isErrorResponse()) {
                            mLog.error("Unsupported Audio Format:" + ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getBroadcastFormat().toString() + " - " + ultravoxMessage.getErrorMessage());
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.UNSUPPORTED_AUDIO_FORMAT);
                            break;
                        }
                        SetupBroadcast setupBroadcast = new SetupBroadcast();
                        setupBroadcast.setBitRate(ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getBitRate(), ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getBitRate());
                        session.write((Object)setupBroadcast);
                        break;
                    }
                    case SETUP_BROADCAST: {
                        if (ultravoxMessage.isErrorResponse()) {
                            mLog.error("Unsupported Audio Bit Rate:" + ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getBitRate() + " - " + ultravoxMessage.getErrorMessage());
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.UNSUPPORTED_AUDIO_FORMAT);
                            break;
                        }
                        NegotiateMaxPayloadSize negotiateMaxPayloadSize = new NegotiateMaxPayloadSize();
                        negotiateMaxPayloadSize.setMaximumPayloadSize(16377, 4192);
                        session.write((Object)negotiateMaxPayloadSize);
                        break;
                    }
                    case NEGOTIATE_MAX_PAYLOAD_SIZE: {
                        if (ultravoxMessage.isErrorResponse()) {
                            mLog.error("Unsupported maximum payload size (18 min - 36 kbps max) - " + ultravoxMessage.getErrorMessage());
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.UNSUPPORTED_AUDIO_FORMAT);
                            break;
                        }
                        ShoutcastV2AudioStreamingBroadcaster.this.mMaxPayloadSize = ((NegotiateMaxPayloadSize)ultravoxMessage).getMaximumPayloadSize();
                        ConfigureIcyPublic configureIcyPublic = new ConfigureIcyPublic();
                        configureIcyPublic.setPublic(ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().isPublic());
                        session.write((Object)configureIcyPublic);
                        break;
                    }
                    case CONFIGURE_ICY_PUBLIC: {
                        if (ultravoxMessage.isErrorResponse()) {
                            mLog.error("Error setting shoutcast stream as public - " + ultravoxMessage.getErrorMessage());
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                            break;
                        }
                        ConfigureIcyName configureIcyName = new ConfigureIcyName();
                        configureIcyName.setName(ShoutcastV2AudioStreamingBroadcaster.this.getConfiguration().getName());
                        session.write((Object)configureIcyName);
                        break;
                    }
                    case CONFIGURE_ICY_NAME: {
                        if (ultravoxMessage.isErrorResponse()) {
                            mLog.error("Error setting shoutcast stream name - " + ultravoxMessage.getErrorMessage());
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.CONFIGURATION_ERROR);
                            break;
                        }
                        session.write((Object)new Standby());
                        break;
                    }
                    case STANDBY: {
                        if (ultravoxMessage.isErrorResponse()) {
                            mLog.error("Error following stream configuration and standby - " + ultravoxMessage.getErrorMessage());
                            ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                            break;
                        }
                        ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.CONNECTED);
                        break;
                    }
                    default: {
                        mLog.error("Unrecognized ultravox message:" + String.valueOf((Object)ultravoxMessage.getMessageType()) + " payload:" + ultravoxMessage.getPayload());
                        ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                    }
                }
            } else {
                mLog.debug("Unrecognized message received from shoutcast v2 server:" + object.toString());
                ShoutcastV2AudioStreamingBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
            }
        }
    }
}

