/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v1;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;

public class ShoutcastV1Configuration
extends BroadcastConfiguration {
    private String mGenre;
    private String mDescription;
    private boolean mPublic;
    private int mChannels = 1;
    private int mBitRate = 16;

    public ShoutcastV1Configuration() {
        this(BroadcastFormat.MP3);
    }

    public ShoutcastV1Configuration(BroadcastFormat format) {
        super(format);
        this.mValid.bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mHost), (ObservableBooleanValue)Bindings.greaterThan((ObservableNumberValue)this.mPort, (int)0)));
    }

    @Override
    public BroadcastConfiguration copyOf() {
        ShoutcastV1Configuration copy = new ShoutcastV1Configuration(this.getBroadcastFormat());
        copy.setName(this.getName());
        copy.setHost(this.getHost());
        copy.setPort(this.getPort());
        copy.setPassword(this.getPassword());
        copy.setDelay(this.getDelay());
        copy.setEnabled(false);
        copy.setGenre(this.getGenre());
        copy.setPublic(this.isPublic());
        copy.setChannels(this.getChannels());
        copy.setBitRate(this.getBitRate());
        return copy;
    }

    @Override
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.SHOUTCAST_V1;
    }

    @JacksonXmlProperty(isAttribute=true, localName="genre")
    public String getGenre() {
        return this.mGenre;
    }

    public void setGenre(String genre) {
        this.mGenre = genre;
    }

    @JacksonXmlProperty(isAttribute=true, localName="description")
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    @JacksonXmlProperty(isAttribute=true, localName="public")
    public boolean isPublic() {
        return this.mPublic;
    }

    public void setPublic(boolean isPublic) {
        this.mPublic = isPublic;
    }

    @JacksonXmlProperty(isAttribute=true, localName="channels")
    public int getChannels() {
        return this.mChannels;
    }

    public void setChannels(int channels) {
        this.mChannels = channels;
    }

    @JacksonXmlProperty(isAttribute=true, localName="bitrate")
    public int getBitRate() {
        return this.mBitRate;
    }

    public void setBitRate(int bitRate) {
        this.mBitRate = bitRate;
    }
}

