/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v1;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.AudioStreamingBroadcaster;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.IBroadcastMetadataUpdater;
import io.github.dsheirer.audio.broadcast.shoutcast.v1.ShoutcastMetadata;
import io.github.dsheirer.audio.broadcast.shoutcast.v1.ShoutcastV1BroadcastMetadataUpdater;
import io.github.dsheirer.audio.broadcast.shoutcast.v1.ShoutcastV1Configuration;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShoutcastV1AudioBroadcaster
extends AudioStreamingBroadcaster {
    private static final Logger mLog = LoggerFactory.getLogger(ShoutcastV1AudioBroadcaster.class);
    private static final long RECONNECT_INTERVAL_MILLISECONDS = 30000L;
    private NioSocketConnector mSocketConnector;
    private IoSession mStreamingSession = null;
    private IBroadcastMetadataUpdater mMetadataUpdater;
    private AliasModel mAliasModel;
    private long mLastConnectionAttempt = 0L;
    private AtomicBoolean mConnecting = new AtomicBoolean();

    public ShoutcastV1AudioBroadcaster(ShoutcastV1Configuration configuration, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting, AliasModel aliasModel) {
        super(configuration, inputAudioFormat, mp3Setting);
        this.mAliasModel = aliasModel;
    }

    private ShoutcastV1Configuration getConfiguration() {
        return (ShoutcastV1Configuration)this.getBroadcastConfiguration();
    }

    @Override
    protected IBroadcastMetadataUpdater getMetadataUpdater() {
        if (this.mMetadataUpdater == null) {
            this.mMetadataUpdater = new ShoutcastV1BroadcastMetadataUpdater(this.getConfiguration(), this.mAliasModel);
        }
        return this.mMetadataUpdater;
    }

    @Override
    protected void broadcastAudio(byte[] audio, IdentifierCollection identifierCollection) {
        if (audio != null && audio.length > 0 && this.connect() && this.mStreamingSession != null && this.mStreamingSession.isConnected()) {
            IoBuffer buf = IoBuffer.allocate((int)audio.length).setAutoExpand(false);
            buf.put(audio);
            buf.flip();
            this.mStreamingSession.write((Object)buf);
        }
    }

    private boolean connect() {
        if (!this.connected() && this.canConnect() && this.mLastConnectionAttempt + 30000L < System.currentTimeMillis() && this.mConnecting.compareAndSet(false, true)) {
            this.mLastConnectionAttempt = System.currentTimeMillis();
            if (this.mSocketConnector == null) {
                this.mSocketConnector = new NioSocketConnector();
                this.mSocketConnector.setConnectTimeoutCheckInterval(10000L);
                this.mSocketConnector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory()));
                this.mSocketConnector.setHandler((IoHandler)new ShoutcastIOHandler());
            }
            this.mStreamingSession = null;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.CONNECTING);
                    try {
                        ConnectFuture future = ShoutcastV1AudioBroadcaster.this.mSocketConnector.connect((SocketAddress)new InetSocketAddress(((BroadcastConfiguration)ShoutcastV1AudioBroadcaster.this.getBroadcastConfiguration()).getHost(), ((BroadcastConfiguration)ShoutcastV1AudioBroadcaster.this.getBroadcastConfiguration()).getPort()));
                        future.awaitUninterruptibly();
                        ShoutcastV1AudioBroadcaster.this.mStreamingSession = future.getSession();
                    }
                    catch (RuntimeIoException rie) {
                        Throwable throwableCause = rie.getCause();
                        if (throwableCause instanceof ConnectException) {
                            ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.NO_SERVER);
                        } else if (throwableCause != null) {
                            ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                            mLog.debug("Failed to connect", (Throwable)rie);
                        } else {
                            ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                            mLog.debug("Failed to connect - no exception is available");
                        }
                        ShoutcastV1AudioBroadcaster.this.disconnect();
                    }
                    catch (Throwable t) {
                        ShoutcastV1AudioBroadcaster.this.disconnect();
                    }
                    ShoutcastV1AudioBroadcaster.this.mConnecting.set(false);
                }
            };
            ThreadPool.CACHED.submit(runnable);
        }
        return this.connected();
    }

    @Override
    public void disconnect() {
        if (this.connected() && this.mStreamingSession != null) {
            this.mStreamingSession.closeNow();
        } else {
            this.mLastConnectionAttempt = System.currentTimeMillis();
        }
    }

    public class ShoutcastIOHandler
    extends IoHandlerAdapter {
        public void sessionOpened(IoSession session) throws Exception {
            StringBuilder sb = new StringBuilder();
            sb.append(ShoutcastV1AudioBroadcaster.this.getConfiguration().getPassword()).append("\n");
            sb.append(ShoutcastMetadata.STREAM_NAME.encode(ShoutcastV1AudioBroadcaster.this.getConfiguration().getName()));
            sb.append(ShoutcastMetadata.PUBLIC.encode(ShoutcastV1AudioBroadcaster.this.getConfiguration().isPublic()));
            sb.append(ShoutcastMetadata.GENRE.encode(ShoutcastV1AudioBroadcaster.this.getConfiguration().getGenre()));
            sb.append(ShoutcastMetadata.DESCRIPTION.encode(ShoutcastV1AudioBroadcaster.this.getConfiguration().getDescription()));
            sb.append(ShoutcastMetadata.AUDIO_BIT_RATE.encode(ShoutcastV1AudioBroadcaster.this.getConfiguration().getBitRate()));
            sb.append("\n");
            session.write((Object)sb.toString());
        }

        public void sessionClosed(IoSession session) throws Exception {
            ShoutcastV1AudioBroadcaster.this.mLastConnectionAttempt = System.currentTimeMillis();
            if (!ShoutcastV1AudioBroadcaster.this.getBroadcastState().isErrorState()) {
                ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
            }
            ShoutcastV1AudioBroadcaster.this.mStreamingSession = null;
            ShoutcastV1AudioBroadcaster.this.mConnecting.set(false);
            super.sessionClosed(session);
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (cause instanceof IOException) {
                IOException ioe = (IOException)cause;
                if (ioe.getMessage() != null) {
                    String reason = ioe.getMessage();
                    if (reason.startsWith("Connection reset")) {
                        mLog.info("Streaming connection reset by remote server - reestablishing connection");
                        ShoutcastV1AudioBroadcaster.this.disconnect();
                    } else if (reason.startsWith("Operation timed out")) {
                        mLog.info("Streaming connection timed out - resetting connection");
                        ShoutcastV1AudioBroadcaster.this.disconnect();
                    } else {
                        ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                        ShoutcastV1AudioBroadcaster.this.disconnect();
                        mLog.error("Unrecognized IO error: " + reason + ". Streaming halted.");
                    }
                } else {
                    ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                    ShoutcastV1AudioBroadcaster.this.disconnect();
                    mLog.error("Unspecified IO error - streaming halted.");
                }
            } else {
                mLog.error("Broadcast error", cause);
                ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                ShoutcastV1AudioBroadcaster.this.disconnect();
            }
            ShoutcastV1AudioBroadcaster.this.mConnecting.set(false);
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            if (object instanceof String) {
                String message = (String)object;
                if (message != null && !message.trim().isEmpty()) {
                    if (message.startsWith("OK")) {
                        ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.CONNECTED);
                    } else if (!message.startsWith("icy-caps:")) {
                        mLog.error("Unrecognized server response:" + message);
                        ShoutcastV1AudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                    }
                }
            } else {
                mLog.error("Icecast TCP broadcaster - unrecognized message [ " + String.valueOf(object.getClass()) + "] received:" + object.toString());
            }
        }
    }
}

