/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v1;

import io.github.dsheirer.audio.broadcast.BroadcastFormat;

public enum ShoutcastMetadata {
    AIM("icy-aim:"),
    AUDIO_BIT_RATE("icy-br:"),
    CHANNELS("icy-channels:"),
    CONTENT_TYPE("Content-Type:"),
    DESCRIPTION("icy-description:"),
    GENRE("icy-genre:"),
    ICE_AUDIO_INFO("ice-audio-info:"),
    ICQ("icy-icq:"),
    INTERNET_RELAY_CHAT("icy-irc:"),
    METADATA_INTERVAL("icy-metaint:"),
    METADATA_REQUEST("icy-metadata:"),
    PRE_BUFFER("icy-prebuffer:"),
    PUBLIC("icy-pub:"),
    RESET("icy-reset:"),
    SERVER("server:"),
    STREAM_NAME("icy-name:"),
    SONG_TITLE("icy-title:"),
    URL("icy-url:"),
    USER_AGENT("User-Agent:"),
    UNKNOWN("Unknown");

    private String mTag;
    public static final String COMMAND_TERMINATOR = "\n";

    private ShoutcastMetadata(String tag) {
        this.mTag = tag;
    }

    public String toString() {
        return this.mTag;
    }

    public String encode(String value) {
        if (value != null && !value.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.mTag).append(value).append(COMMAND_TERMINATOR);
            return sb.toString();
        }
        return null;
    }

    public String encode(boolean value) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mTag).append(value ? "1" : "0").append(COMMAND_TERMINATOR);
        return sb.toString();
    }

    public String encode(BroadcastFormat broadcastFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mTag).append(broadcastFormat.getValue()).append(COMMAND_TERMINATOR);
        return sb.toString();
    }

    public String encode(int value) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mTag).append(String.valueOf(value)).append(COMMAND_TERMINATOR);
        return sb.toString();
    }
}

