/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.icecast;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.icecast.IcecastHTTPConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.IcecastTCPConfiguration;
import java.util.Base64;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=IcecastHTTPConfiguration.class, name="icecastHTTPConfiguration"), @JsonSubTypes.Type(value=IcecastTCPConfiguration.class, name="icecastTCPConfiguration")})
public abstract class IcecastConfiguration
extends BroadcastConfiguration {
    protected String mUserName = "source";
    protected StringProperty mMountPoint = new SimpleStringProperty("/stream");
    private String mDescription;
    private String mGenre;
    private boolean mPublic;
    private int mBitRate = 16;
    private int mChannels = 1;
    private int mSampleRate = 8000;
    private String mURL;
    private boolean mInline = true;

    public IcecastConfiguration(BroadcastFormat format) {
        super(format);
    }

    public IcecastConfiguration() {
        this(BroadcastFormat.MP3);
    }

    @JsonIgnore
    public String getBase64EncodedCredentials() {
        StringBuilder sb = new StringBuilder();
        if (this.hasUserName()) {
            sb.append(this.getUserName()).append(":").append(this.getPassword());
        } else {
            sb.append(this.getPassword());
        }
        String base64 = Base64.getEncoder().encodeToString(sb.toString().getBytes());
        return "Basic " + base64;
    }

    @JacksonXmlProperty(isAttribute=true, localName="user_name")
    public String getUserName() {
        return this.mUserName;
    }

    public void setUserName(String userName) {
        this.mUserName = userName;
    }

    public boolean hasUserName() {
        return this.mUserName != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="mount_point")
    public String getMountPoint() {
        return (String)this.mMountPoint.get();
    }

    public void setMountPoint(String mountPoint) {
        if (mountPoint != null && !mountPoint.isEmpty()) {
            if (mountPoint.startsWith("/")) {
                this.mMountPoint.setValue(mountPoint);
            } else {
                this.mMountPoint.setValue("/" + mountPoint);
            }
        }
    }

    public boolean hasMountPoint() {
        return this.mMountPoint.get() != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="description")
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public boolean hasDescription() {
        return this.mDescription != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="genre")
    public String getGenre() {
        return this.mGenre;
    }

    public void setGenre(String genre) {
        this.mGenre = genre;
    }

    public boolean hasGenre() {
        return this.mGenre != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="public")
    public boolean isPublic() {
        return this.mPublic;
    }

    public void setPublic(boolean isPublic) {
        this.mPublic = isPublic;
    }

    @JacksonXmlProperty(isAttribute=true, localName="channels")
    public int getChannels() {
        return this.mChannels;
    }

    public void setChannels(int channels) {
        this.mChannels = channels;
    }

    public boolean hasChannels() {
        return this.mChannels > 0;
    }

    @JacksonXmlProperty(isAttribute=true, localName="bitrate")
    public int getBitRate() {
        return this.mBitRate;
    }

    public void setBitRate(int bitRate) {
        this.mBitRate = bitRate;
    }

    public boolean hasBitRate() {
        return this.mBitRate > 0;
    }

    @JacksonXmlProperty(isAttribute=true, localName="sample_rate")
    public int getSampleRate() {
        return this.mSampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
    }

    public boolean hasSampleRate() {
        return this.mSampleRate > 0;
    }

    @JacksonXmlProperty(isAttribute=true, localName="url")
    public String getURL() {
        return this.mURL;
    }

    public void setURL(String url) {
        this.mURL = url;
    }

    public boolean hasURL() {
        return this.mURL != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="inline")
    public boolean getInline() {
        return this.mInline;
    }

    @JsonIgnore
    public int getInlineInterval() {
        if (this.hasBitRate()) {
            return this.getBitRate() * 125;
        }
        return -1;
    }

    public void setInline(boolean inline) {
        this.mInline = inline;
    }

    public boolean hasInline() {
        return this.mInline && this.hasBitRate();
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.getUserName() == null) {
            return false;
        }
        if (this.getMountPoint() == null) {
            return false;
        }
        if (this.getChannels() != 1) {
            return false;
        }
        if (this.getSampleRate() <= 0) {
            return false;
        }
        return this.getBitRate() > 0;
    }
}

