/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.AbstractAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyCallBroadcaster;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyCallConfiguration;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyFeedConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.IcecastHTTPAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.icecast.IcecastHTTPConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.IcecastTCPAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.icecast.IcecastTCPConfiguration;
import io.github.dsheirer.audio.broadcast.openmhz.OpenMHzBroadcaster;
import io.github.dsheirer.audio.broadcast.openmhz.OpenMHzConfiguration;
import io.github.dsheirer.audio.broadcast.rdioscanner.RdioScannerBroadcaster;
import io.github.dsheirer.audio.broadcast.rdioscanner.RdioScannerConfiguration;
import io.github.dsheirer.audio.broadcast.shoutcast.v1.ShoutcastV1AudioBroadcaster;
import io.github.dsheirer.audio.broadcast.shoutcast.v1.ShoutcastV1Configuration;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ShoutcastV2AudioStreamingBroadcaster;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ShoutcastV2Configuration;
import io.github.dsheirer.audio.convert.ISilenceGenerator;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.audio.convert.MP3SilenceGenerator;
import io.github.dsheirer.preference.UserPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastFactory {
    private static final Logger mLog = LoggerFactory.getLogger(BroadcastFactory.class);

    public static AbstractAudioBroadcaster getBroadcaster(BroadcastConfiguration configuration, AliasModel aliasModel, UserPreferences userPreferences) {
        if (configuration != null) {
            InputAudioFormat inputAudioFormat = userPreferences.getMP3Preference().getAudioSampleRate();
            MP3Setting mp3Setting = userPreferences.getMP3Preference().getMP3Setting();
            switch (configuration.getBroadcastServerType()) {
                case BROADCASTIFY_CALL: {
                    return new BroadcastifyCallBroadcaster((BroadcastifyCallConfiguration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
                case RDIOSCANNER_CALL: {
                    return new RdioScannerBroadcaster((RdioScannerConfiguration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
                case OPENMHZ: {
                    return new OpenMHzBroadcaster((OpenMHzConfiguration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
                case BROADCASTIFY: {
                    return new IcecastTCPAudioBroadcaster((BroadcastifyFeedConfiguration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
                case ICECAST_TCP: {
                    return new IcecastTCPAudioBroadcaster((IcecastTCPConfiguration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
                case ICECAST_HTTP: {
                    return new IcecastHTTPAudioBroadcaster((IcecastHTTPConfiguration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
                case SHOUTCAST_V1: {
                    return new ShoutcastV1AudioBroadcaster((ShoutcastV1Configuration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
                case SHOUTCAST_V2: {
                    return new ShoutcastV2AudioStreamingBroadcaster((ShoutcastV2Configuration)configuration, inputAudioFormat, mp3Setting, aliasModel);
                }
            }
            mLog.info("Unrecognized broadcastAudio configuration: " + configuration.getBroadcastFormat().name());
        }
        return null;
    }

    public static BroadcastConfiguration getConfiguration(BroadcastServerType serverType, BroadcastFormat format) {
        switch (serverType) {
            case BROADCASTIFY_CALL: {
                return new BroadcastifyCallConfiguration(format);
            }
            case RDIOSCANNER_CALL: {
                return new RdioScannerConfiguration(format);
            }
            case BROADCASTIFY: {
                return new BroadcastifyFeedConfiguration(format);
            }
            case OPENMHZ: {
                return new OpenMHzConfiguration(format);
            }
            case ICECAST_HTTP: {
                return new IcecastHTTPConfiguration(format);
            }
            case ICECAST_TCP: {
                return new IcecastTCPConfiguration(format);
            }
            case SHOUTCAST_V1: {
                return new ShoutcastV1Configuration(format);
            }
            case SHOUTCAST_V2: {
                return new ShoutcastV2Configuration(format);
            }
        }
        mLog.info("Unrecognized broadcastAudio server type: " + serverType.name());
        return null;
    }

    public static ISilenceGenerator getSilenceGenerator(BroadcastFormat format, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting) {
        switch (format) {
            case MP3: {
                return new MP3SilenceGenerator(inputAudioFormat, mp3Setting);
            }
        }
        throw new IllegalArgumentException("Unrecognized broadcast format [" + String.valueOf((Object)format) + "] can't create silence generator");
    }
}

