/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyCallConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.IcecastConfiguration;
import io.github.dsheirer.audio.broadcast.openmhz.OpenMHzConfiguration;
import io.github.dsheirer.audio.broadcast.rdioscanner.RdioScannerConfiguration;
import io.github.dsheirer.audio.broadcast.shoutcast.v1.ShoutcastV1Configuration;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ShoutcastV2Configuration;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BroadcastifyCallConfiguration.class, name="broadcastifyCallConfiguration"), @JsonSubTypes.Type(value=RdioScannerConfiguration.class, name="RdioScannerConfiguration"), @JsonSubTypes.Type(value=OpenMHzConfiguration.class, name="OpenMHzConfiguration"), @JsonSubTypes.Type(value=IcecastConfiguration.class, name="icecastConfiguration"), @JsonSubTypes.Type(value=ShoutcastV1Configuration.class, name="shoutcastV1Configuration"), @JsonSubTypes.Type(value=ShoutcastV2Configuration.class, name="shoutcastV2Configuration")})
@JacksonXmlRootElement(localName="stream")
public abstract class BroadcastConfiguration {
    private static final Logger mLog = LoggerFactory.getLogger(BroadcastConfiguration.class);
    private static int UNIQUE_ID = 0;
    private BroadcastFormat mBroadcastFormat = BroadcastFormat.MP3;
    protected StringProperty mName = new SimpleStringProperty();
    protected StringProperty mHost = new SimpleStringProperty();
    protected IntegerProperty mPort = new SimpleIntegerProperty(80);
    protected StringProperty mPassword = new SimpleStringProperty();
    protected LongProperty mDelay = new SimpleLongProperty();
    protected LongProperty mMaximumRecordingAge = new SimpleLongProperty(600000L);
    protected BooleanProperty mEnabled = new SimpleBooleanProperty(false);
    protected BooleanProperty mValid = new SimpleBooleanProperty();
    private int mId = ++UNIQUE_ID;

    public BroadcastConfiguration() {
    }

    @JsonIgnore
    public int getId() {
        return this.mId;
    }

    public abstract BroadcastConfiguration copyOf();

    public BroadcastConfiguration(BroadcastFormat format) {
        this.mBroadcastFormat = format;
    }

    public StringProperty nameProperty() {
        return this.mName;
    }

    public StringProperty hostProperty() {
        return this.mHost;
    }

    public IntegerProperty portProperty() {
        return this.mPort;
    }

    public StringProperty passwordProperty() {
        return this.mPassword;
    }

    public LongProperty delayProperty() {
        return this.mDelay;
    }

    public LongProperty maximumRecordingAgeProperty() {
        return this.mMaximumRecordingAge;
    }

    public BooleanProperty enabledProperty() {
        return this.mEnabled;
    }

    public BooleanProperty validProperty() {
        return this.mValid;
    }

    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public abstract BroadcastServerType getBroadcastServerType();

    private void setBroadcastServerType(BroadcastServerType type) {
    }

    @JacksonXmlProperty(isAttribute=true, localName="name")
    public String getName() {
        return (String)this.mName.get();
    }

    public void setName(String name) {
        this.mName.set((Object)name);
    }

    public boolean hasName() {
        return this.mName != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="host")
    public String getHost() {
        return (String)this.mHost.get();
    }

    public void setHost(String host) {
        this.mHost.set((Object)host);
    }

    public boolean hasHost() {
        return this.mHost != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="port")
    public int getPort() {
        return this.mPort.get();
    }

    public void setPort(int port) {
        this.mPort.set(port);
    }

    public boolean hasPort() {
        return this.mPort.get() > 0;
    }

    @JsonIgnore
    public SocketAddress getAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    @JacksonXmlProperty(isAttribute=true, localName="password")
    public String getPassword() {
        return (String)this.mPassword.get();
    }

    public void setPassword(String password) {
        this.mPassword.set((Object)password);
    }

    public boolean hasPassword() {
        return this.mPassword != null;
    }

    @JacksonXmlProperty(isAttribute=false, localName="format")
    public BroadcastFormat getBroadcastFormat() {
        return this.mBroadcastFormat;
    }

    public void setBroadcastFormat(BroadcastFormat format) {
        this.mBroadcastFormat = format;
    }

    @JacksonXmlProperty(isAttribute=true, localName="delay")
    public long getDelay() {
        return this.mDelay.get();
    }

    public void setDelay(long delay) {
        this.mDelay.set(delay);
    }

    @JacksonXmlProperty(isAttribute=true, localName="maximum_recording_age")
    public long getMaximumRecordingAge() {
        return this.mMaximumRecordingAge.get();
    }

    public void setMaximumRecordingAge(long age) {
        this.mMaximumRecordingAge.set(age);
    }

    @JacksonXmlProperty(isAttribute=true, localName="enabled")
    public boolean isEnabled() {
        return this.mEnabled.get();
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled.set(enabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BroadcastConfiguration)) {
            return false;
        }
        BroadcastConfiguration that = (BroadcastConfiguration)o;
        if (this.getBroadcastFormat() != that.getBroadcastFormat()) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return this.getBroadcastServerType() == that.getBroadcastServerType();
    }

    public int hashCode() {
        int result = this.getBroadcastFormat().hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + this.getBroadcastServerType().hashCode();
        return result;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.mValid.get();
    }

    /*
     * Exception decompiling
     */
    public static Callback<BroadcastConfiguration, Observable[]> extractor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

