/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import io.github.dsheirer.audio.broadcast.AbstractAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.AudioRecording;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastEvent;
import io.github.dsheirer.audio.broadcast.BroadcastFactory;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.IBroadcastMetadataUpdater;
import io.github.dsheirer.audio.convert.AudioFrames;
import io.github.dsheirer.audio.convert.ISilenceGenerator;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3FrameTools;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AudioStreamingBroadcaster<T extends BroadcastConfiguration>
extends AbstractAudioBroadcaster<T> {
    private static final Logger mLog = LoggerFactory.getLogger(AudioStreamingBroadcaster.class);
    public static final int PROCESSOR_RUN_INTERVAL_MS = 1000;
    private ScheduledFuture<?> mRecordingQueueProcessorFuture;
    private RecordingQueueProcessor mRecordingQueueProcessor = new RecordingQueueProcessor();
    private Queue<AudioRecording> mAudioRecordingQueue = new LinkedTransferQueue<AudioRecording>();
    private ISilenceGenerator mSilenceGenerator;
    private BroadcastFormat mBroadcastFormat;
    private long mDelay;
    private long mMaximumRecordingAge;
    private AtomicBoolean mStreaming = new AtomicBoolean();
    protected boolean mInlineActive = false;
    protected int mInlineInterval;
    protected int mInlineRemaining = -1;
    private int mTimeOverrun = 0;

    public AudioStreamingBroadcaster(T broadcastConfiguration, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting) {
        super(broadcastConfiguration);
        this.mBroadcastFormat = ((BroadcastConfiguration)broadcastConfiguration).getBroadcastFormat();
        this.mDelay = ((BroadcastConfiguration)this.getBroadcastConfiguration()).getDelay();
        this.mMaximumRecordingAge = ((BroadcastConfiguration)this.getBroadcastConfiguration()).getMaximumRecordingAge();
        this.mSilenceGenerator = BroadcastFactory.getSilenceGenerator(((BroadcastConfiguration)broadcastConfiguration).getBroadcastFormat(), inputAudioFormat, mp3Setting);
    }

    @Override
    public void dispose() {
    }

    protected abstract void broadcastAudio(byte[] var1, IdentifierCollection var2);

    protected abstract IBroadcastMetadataUpdater getMetadataUpdater();

    protected void broadcastMetadata(IdentifierCollection identifierCollection) {
        IBroadcastMetadataUpdater metadataUpdater = this.getMetadataUpdater();
        if (metadataUpdater != null) {
            metadataUpdater.update(identifierCollection);
        }
    }

    protected abstract void disconnect();

    @Override
    public void start() {
        if (this.mStreaming.compareAndSet(false, true) && this.mRecordingQueueProcessorFuture == null) {
            this.mRecordingQueueProcessorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(this.mRecordingQueueProcessor, 0L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.mStreaming.compareAndSet(true, false)) {
            if (this.mRecordingQueueProcessorFuture != null) {
                this.mRecordingQueueProcessorFuture.cancel(true);
                this.mRecordingQueueProcessorFuture = null;
            }
            this.disconnect();
        }
    }

    public String getStreamName() {
        Object config = this.getBroadcastConfiguration();
        if (config != null) {
            return ((BroadcastConfiguration)config).getName();
        }
        return null;
    }

    @Override
    public int getAudioQueueSize() {
        return this.mAudioRecordingQueue.size();
    }

    @Override
    public void receive(AudioRecording recording) {
        if (this.connected()) {
            this.mAudioRecordingQueue.offer(recording);
            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_QUEUE_CHANGE));
        } else {
            recording.removePendingReplay();
        }
    }

    @Override
    public void setBroadcastState(BroadcastState state) {
        if (this.mBroadcastState.get() != state) {
            if (state == BroadcastState.CONNECTED || state == BroadcastState.DISCONNECTED) {
                mLog.info("[" + this.getStreamName() + "] status: " + String.valueOf((Object)state));
            }
            super.setBroadcastState(state);
            if (this.mBroadcastState.get() != null && ((BroadcastState)((Object)this.mBroadcastState.get())).isErrorState()) {
                this.stop();
            }
            if (!this.connected()) {
                this.mInlineRemaining = -1;
                while (!this.mAudioRecordingQueue.isEmpty()) {
                    try {
                        AudioRecording recording = this.mAudioRecordingQueue.remove();
                        recording.removePendingReplay();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected boolean connected() {
        return this.getBroadcastState() == BroadcastState.CONNECTED;
    }

    public boolean canConnect() {
        BroadcastState state = this.getBroadcastState();
        return state != BroadcastState.CONNECTED && !state.isErrorState();
    }

    protected boolean isErrorState() {
        return this.getBroadcastState().isErrorState();
    }

    public class RecordingQueueProcessor
    implements Runnable {
        private AtomicBoolean mProcessing = new AtomicBoolean();
        private AudioFrames mInputFrames;
        private IdentifierCollection mInputIdentifierCollection;

        @Override
        public void run() {
            if (this.mProcessing.compareAndSet(false, true)) {
                try {
                    int timeSent = 0;
                    if (this.mInputFrames == null || !this.mInputFrames.hasNextFrame()) {
                        this.nextRecording();
                    }
                    if (this.mInputFrames != null && this.mInputFrames.hasNextFrame()) {
                        while (this.mInputFrames.hasNextFrame() && timeSent < 1000) {
                            this.mInputFrames.nextFrame();
                            AudioStreamingBroadcaster.this.broadcastAudio(this.mInputFrames.getCurrentFrame(), this.mInputIdentifierCollection);
                            timeSent += this.mInputFrames.getCurrentFrameDuration();
                        }
                    }
                    if (!(this.mInputFrames != null && this.mInputFrames.hasNextFrame() || timeSent >= 1000)) {
                        AudioFrames silenceFrames = AudioStreamingBroadcaster.this.mSilenceGenerator.generate(1000 - AudioStreamingBroadcaster.this.mTimeOverrun - timeSent);
                        while (silenceFrames.hasNextFrame()) {
                            silenceFrames.nextFrame();
                            AudioStreamingBroadcaster.this.broadcastAudio(silenceFrames.getCurrentFrame(), null);
                            timeSent += silenceFrames.getCurrentFrameDuration();
                        }
                    }
                    AudioStreamingBroadcaster.this.mTimeOverrun += timeSent - 1000;
                }
                catch (Throwable t) {
                    mLog.error("Error while processing audio streaming queue", t);
                }
                this.mProcessing.set(false);
            }
        }

        private void nextRecording() {
            boolean metadataUpdateRequired = false;
            if (this.mInputFrames != null) {
                ++AudioStreamingBroadcaster.this.mStreamedAudioCount;
                AudioStreamingBroadcaster.this.broadcast(new BroadcastEvent(AudioStreamingBroadcaster.this, BroadcastEvent.Event.BROADCASTER_STREAMED_COUNT_CHANGE));
                metadataUpdateRequired = true;
            }
            this.mInputFrames = null;
            this.mInputIdentifierCollection = null;
            AudioRecording nextRecording = AudioStreamingBroadcaster.this.mAudioRecordingQueue.peek();
            while (nextRecording != null && nextRecording.getStartTime() + AudioStreamingBroadcaster.this.mDelay + AudioStreamingBroadcaster.this.mMaximumRecordingAge < System.currentTimeMillis()) {
                nextRecording = AudioStreamingBroadcaster.this.mAudioRecordingQueue.remove();
                nextRecording.removePendingReplay();
                ++AudioStreamingBroadcaster.this.mAgedOffAudioCount;
                AudioStreamingBroadcaster.this.broadcast(new BroadcastEvent(AudioStreamingBroadcaster.this, BroadcastEvent.Event.BROADCASTER_AGED_OFF_COUNT_CHANGE));
                nextRecording = AudioStreamingBroadcaster.this.mAudioRecordingQueue.peek();
            }
            if (nextRecording != null && nextRecording.getStartTime() + AudioStreamingBroadcaster.this.mDelay <= System.currentTimeMillis()) {
                nextRecording = AudioStreamingBroadcaster.this.mAudioRecordingQueue.remove();
                try {
                    byte[] audio;
                    if (Files.exists(nextRecording.getPath(), new LinkOption[0]) && (audio = Files.readAllBytes(nextRecording.getPath())).length > 0) {
                        switch (AudioStreamingBroadcaster.this.mBroadcastFormat) {
                            case MP3: {
                                this.mInputFrames = MP3FrameTools.split(audio);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported broadcast format [" + String.valueOf((Object)AudioStreamingBroadcaster.this.mBroadcastFormat) + "]");
                            }
                        }
                        this.mInputIdentifierCollection = nextRecording.getIdentifierCollection();
                        if (AudioStreamingBroadcaster.this.connected()) {
                            AudioStreamingBroadcaster.this.broadcastMetadata(nextRecording.getIdentifierCollection());
                        }
                        metadataUpdateRequired = false;
                    }
                }
                catch (IOException ioe) {
                    mLog.error("Stream [" + ((BroadcastConfiguration)AudioStreamingBroadcaster.this.getBroadcastConfiguration()).getName() + "] error reading temporary audio stream recording [" + nextRecording.getPath().toString() + "] - skipping recording - ", (Throwable)ioe);
                    this.mInputFrames = null;
                    this.mInputIdentifierCollection = null;
                    metadataUpdateRequired = false;
                }
                nextRecording.removePendingReplay();
                AudioStreamingBroadcaster.this.broadcast(new BroadcastEvent(AudioStreamingBroadcaster.this, BroadcastEvent.Event.BROADCASTER_QUEUE_CHANGE));
            }
            if (metadataUpdateRequired && AudioStreamingBroadcaster.this.connected()) {
                AudioStreamingBroadcaster.this.broadcastMetadata(null);
            }
        }
    }
}

