/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio;

import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.SystemConfigurationIdentifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.duplicate.DuplicateCallDetectionPreference;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.ThreadPool;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCallDetector
implements Listener<AudioSegment> {
    private static final Logger mLog = LoggerFactory.getLogger(DuplicateCallDetector.class);
    private DuplicateCallDetectionPreference mDuplicateCallDetectionPreference;
    private Map<String, SystemDuplicateCallDetector> mDetectorMap = new HashMap<String, SystemDuplicateCallDetector>();

    public DuplicateCallDetector(UserPreferences userPreferences) {
        this.mDuplicateCallDetectionPreference = userPreferences.getDuplicateCallDetectionPreference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(AudioSegment audioSegment) {
        Identifier identifier;
        if (this.mDuplicateCallDetectionPreference.isDuplicateCallDetectionEnabled() && (identifier = audioSegment.getIdentifierCollection().getIdentifier(IdentifierClass.CONFIGURATION, Form.SYSTEM, Role.ANY)) instanceof SystemConfigurationIdentifier) {
            String system = (String)((SystemConfigurationIdentifier)identifier).getValue();
            Map<String, SystemDuplicateCallDetector> map = this.mDetectorMap;
            synchronized (map) {
                SystemDuplicateCallDetector detector = this.mDetectorMap.get(system);
                if (detector == null) {
                    detector = new SystemDuplicateCallDetector();
                    this.mDetectorMap.put(system, detector);
                }
                detector.add(audioSegment);
            }
        }
    }

    public class SystemDuplicateCallDetector {
        private LinkedTransferQueue<AudioSegment> mAudioSegmentQueue = new LinkedTransferQueue();
        private List<AudioSegment> mAudioSegments = new ArrayList<AudioSegment>();
        private AtomicBoolean mMonitoring = new AtomicBoolean();
        private ScheduledFuture<?> mProcessorFuture;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(AudioSegment audioSegment) {
            LinkedTransferQueue<AudioSegment> linkedTransferQueue = this.mAudioSegmentQueue;
            synchronized (linkedTransferQueue) {
                this.mAudioSegmentQueue.add(audioSegment);
                this.startMonitoring();
            }
        }

        private void startMonitoring() {
            if (this.mMonitoring.compareAndSet(false, true)) {
                this.mProcessorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(() -> this.process(), 0L, 25L, TimeUnit.MILLISECONDS);
            }
        }

        private void stopMonitoring() {
            if (this.mMonitoring.compareAndSet(true, false) && this.mProcessorFuture != null) {
                this.mProcessorFuture.cancel(true);
            }
        }

        private boolean isDuplicate(AudioSegment segment1, AudioSegment segment2) {
            List<Identifier> to2;
            List<Identifier> to1;
            if (DuplicateCallDetector.this.mDuplicateCallDetectionPreference.isDuplicateCallDetectionByTalkgroupEnabled() && this.isDuplicate(to1 = segment1.getIdentifierCollection().getIdentifiers(Role.TO), to2 = segment2.getIdentifierCollection().getIdentifiers(Role.TO))) {
                return true;
            }
            if (DuplicateCallDetector.this.mDuplicateCallDetectionPreference.isDuplicateCallDetectionByRadioEnabled()) {
                List<Identifier> from1 = segment1.getIdentifierCollection().getIdentifiers(Role.FROM);
                List<Identifier> from2 = segment2.getIdentifierCollection().getIdentifiers(Role.FROM);
                return this.isDuplicate(from1, from2);
            }
            return false;
        }

        private boolean isDuplicate(List<Identifier> identifiers1, List<Identifier> identifiers2) {
            for (Identifier identifier1 : identifiers1) {
                int talkgroup1;
                if (identifier1 instanceof TalkgroupIdentifier) {
                    talkgroup1 = (Integer)((TalkgroupIdentifier)identifier1).getValue();
                    for (Identifier identifier2 : identifiers2) {
                        if (identifier2 instanceof TalkgroupIdentifier && (Integer)((TalkgroupIdentifier)identifier2).getValue() == talkgroup1) {
                            return true;
                        }
                        if (!(identifier2 instanceof PatchGroupIdentifier) || (Integer)((PatchGroup)((PatchGroupIdentifier)identifier2).getValue()).getPatchGroup().getValue() != talkgroup1) continue;
                        return true;
                    }
                    continue;
                }
                if (identifier1 instanceof PatchGroupIdentifier) {
                    talkgroup1 = (Integer)((PatchGroup)((PatchGroupIdentifier)identifier1).getValue()).getPatchGroup().getValue();
                    for (Identifier identifier2 : identifiers2) {
                        if (identifier2 instanceof TalkgroupIdentifier && (Integer)((TalkgroupIdentifier)identifier2).getValue() == talkgroup1) {
                            return true;
                        }
                        if (!(identifier2 instanceof PatchGroupIdentifier) || (Integer)((PatchGroup)((PatchGroupIdentifier)identifier2).getValue()).getPatchGroup().getValue() != talkgroup1) continue;
                        return true;
                    }
                    continue;
                }
                if (!(identifier1 instanceof RadioIdentifier)) continue;
                int radio1 = (Integer)((RadioIdentifier)identifier1).getValue();
                for (Identifier identifier2 : identifiers2) {
                    if (!(identifier2 instanceof RadioIdentifier) || (Integer)((RadioIdentifier)identifier2).getValue() != radio1) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() {
            block11: {
                try {
                    AbstractCollection duplicates;
                    this.mAudioSegmentQueue.drainTo(this.mAudioSegments);
                    this.mAudioSegments.removeIf(audioSegment -> {
                        boolean complete = audioSegment.completeProperty().get();
                        if (complete) {
                            audioSegment.decrementConsumerCount();
                        }
                        return complete;
                    });
                    if (this.mAudioSegments.size() > 1) {
                        duplicates = new ArrayList();
                        for (int currentIndex = 0; currentIndex < this.mAudioSegments.size() - 1; ++currentIndex) {
                            AudioSegment current = this.mAudioSegments.get(currentIndex);
                            if (current.isDuplicate()) continue;
                            for (int checkIndex = currentIndex + 1; checkIndex < this.mAudioSegments.size(); ++checkIndex) {
                                AudioSegment toCheck = this.mAudioSegments.get(checkIndex);
                                if (toCheck.isDuplicate() || !this.isDuplicate(current, toCheck)) continue;
                                toCheck.setDuplicate(true);
                                toCheck.decrementConsumerCount();
                                duplicates.add(toCheck);
                            }
                        }
                        this.mAudioSegments.removeAll(duplicates);
                    }
                    if (!this.mAudioSegments.isEmpty()) break block11;
                    duplicates = this.mAudioSegmentQueue;
                    synchronized (duplicates) {
                        if (this.mAudioSegmentQueue.isEmpty()) {
                            try {
                                this.stopMonitoring();
                            }
                            catch (Exception e) {
                                mLog.error("Unexpected error during duplicate audio segment monitoring shutdown", (Throwable)e);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    mLog.error("Unknown error while processing audio segments for duplicate call detection.  Please report this to the developer.", t);
                }
            }
        }
    }
}

