/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.AbstractAudioModule;
import io.github.dsheirer.audio.squelch.ISquelchStateListener;
import io.github.dsheirer.audio.squelch.SquelchState;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.fir.remez.RemezFIRFilterDesigner;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.real.IRealBufferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioModule
extends AbstractAudioModule
implements ISquelchStateListener,
IRealBufferListener,
Listener<float[]> {
    private static final Logger mLog = LoggerFactory.getLogger(AudioModule.class);
    private static float[] sHighPassFilterCoefficients;
    private final boolean mAudioFilterEnable;
    private final IRealFilter mHighPassFilter = FilterFactory.getRealFilter(sHighPassFilterCoefficients);
    private final SquelchStateListener mSquelchStateListener = new SquelchStateListener();
    private SquelchState mSquelchState = SquelchState.SQUELCH;

    public AudioModule(AliasList aliasList, int timeslot, long maxAudioSegmentLength, boolean audioFilterEnable) {
        super(aliasList, timeslot, maxAudioSegmentLength);
        this.mAudioFilterEnable = audioFilterEnable;
    }

    public AudioModule(AliasList aliasList, boolean audioFilterEnable) {
        super(aliasList);
        this.mAudioFilterEnable = audioFilterEnable;
    }

    @Override
    protected int getTimeslot() {
        return 0;
    }

    @Override
    public void reset() {
        this.getIdentifierCollection().clear();
    }

    @Override
    public void start() {
    }

    @Override
    public Listener<SquelchStateEvent> getSquelchStateListener() {
        return this.mSquelchStateListener;
    }

    @Override
    public void receive(float[] audioBuffer) {
        if (this.mSquelchState == SquelchState.UNSQUELCH) {
            if (this.mAudioFilterEnable) {
                audioBuffer = this.mHighPassFilter.filter(audioBuffer);
            }
            this.addAudio(audioBuffer);
        }
    }

    @Override
    public Listener<float[]> getBufferListener() {
        return this;
    }

    static {
        FIRFilterSpecification specification = FIRFilterSpecification.highPassBuilder().sampleRate(8000.0).stopBandCutoff(200).stopBandAmplitude(0.0).stopBandRipple(0.025).passBandStart(300).passBandAmplitude(1.0).passBandRipple(0.01).build();
        try {
            RemezFIRFilterDesigner designer = new RemezFIRFilterDesigner(specification);
            if (designer.isValid()) {
                sHighPassFilterCoefficients = designer.getImpulseResponse();
            }
        }
        catch (FilterDesignException fde) {
            mLog.error("Filter design error", (Throwable)fde);
        }
    }

    public class SquelchStateListener
    implements Listener<SquelchStateEvent> {
        @Override
        public void receive(SquelchStateEvent event) {
            SquelchState squelchState = event.getSquelchState();
            if (AudioModule.this.mSquelchState != squelchState) {
                AudioModule.this.mSquelchState = squelchState;
                if (AudioModule.this.mSquelchState == SquelchState.SQUELCH) {
                    AudioModule.this.closeAudioSegment();
                }
            }
        }
    }
}

