/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.radio;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.radio.RadioFormat;
import io.github.dsheirer.alias.id.radio.RadioFormatter;
import io.github.dsheirer.protocol.Protocol;

public class RadioRange
extends AliasID
implements Comparable<RadioRange> {
    private Protocol mProtocol = Protocol.UNKNOWN;
    private int mMinRadio;
    private int mMaxRadio;

    public RadioRange() {
    }

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    public RadioRange(Protocol protocol, int minRadio, int maxRadio) {
        this.mProtocol = protocol;
        this.mMinRadio = minRadio;
        this.mMaxRadio = maxRadio;
    }

    @JacksonXmlProperty(isAttribute=true, localName="min")
    public int getMinRadio() {
        return this.mMinRadio;
    }

    public void setMinRadio(int minRadio) {
        this.mMinRadio = minRadio;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="max")
    public int getMaxRadio() {
        return this.mMaxRadio;
    }

    public void setMaxRadio(int maxRadio) {
        this.mMaxRadio = maxRadio;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="protocol")
    public Protocol getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.mProtocol = protocol;
    }

    @Override
    public boolean isValid() {
        if (this.mProtocol == null || this.mProtocol == Protocol.UNKNOWN) {
            return false;
        }
        RadioFormat radioFormat = RadioFormat.get(this.mProtocol);
        return radioFormat.getMinimumValidValue() <= this.mMinRadio && this.mMinRadio <= radioFormat.getMaximumValidValue() && radioFormat.getMinimumValidValue() <= this.mMaxRadio && this.mMaxRadio <= radioFormat.getMaximumValidValue() && this.mMinRadio < this.mMaxRadio;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Radio ID Range:").append(RadioFormatter.format(this.mProtocol, this.mMinRadio));
        sb.append(" to ").append(RadioFormatter.format(this.mProtocol, this.mMaxRadio));
        sb.append(" Protocol:").append(this.mProtocol != null ? this.mProtocol : "unspecified");
        if (!this.isValid()) {
            sb.append(" **NOT VALID**");
        }
        return sb.toString();
    }

    @Override
    public boolean matches(AliasID id) {
        if (id instanceof RadioRange) {
            RadioRange tgid = (RadioRange)id;
            return this.getProtocol() == tgid.getProtocol() && this.getMinRadio() == tgid.getMinRadio() && this.getMaxRadio() == tgid.getMaxRadio();
        }
        return false;
    }

    public boolean contains(int radioValue) {
        return this.getMinRadio() <= radioValue && radioValue <= this.getMaxRadio();
    }

    @Override
    public boolean overlaps(AliasID other) {
        return other instanceof RadioRange && this.overlaps((RadioRange)other);
    }

    public boolean overlaps(RadioRange radioRange) {
        return this.contains(radioRange.getMinRadio()) || this.contains(radioRange.getMaxRadio()) || this.getMinRadio() < radioRange.getMinRadio() && radioRange.getMaxRadio() < this.getMaxRadio() || radioRange.getMinRadio() < this.getMinRadio() && this.getMaxRadio() < radioRange.getMaxRadio();
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.RADIO_ID_RANGE;
    }

    @Override
    public int compareTo(RadioRange other) {
        if (other == null) {
            return -1;
        }
        if (this.getProtocol().equals((Object)other.getProtocol())) {
            if (this.getMinRadio() == other.getMinRadio()) {
                return Integer.compare(this.getMaxRadio(), other.getMaxRadio());
            }
            return Integer.compare(this.getMinRadio(), other.getMinRadio());
        }
        return this.getProtocol().compareTo(other.getProtocol());
    }
}

