/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.radio;

import io.github.dsheirer.protocol.Protocol;

public enum RadioFormat {
    APCO25("********", 0, 0xFFFFFF, "0 to 16,777,215", "<html>APCO25 valid range is 0 to 16,777,215"),
    DMR("********", 0, 0xFFFFFF, "0 to 16,777,215", "<html>DMR unit id valid range is 0 to 16,777,215"),
    PASSPORT("********", 0, 0x7FFFFF, "0 to 8,388,607", "<html>PASSPORT valid range is 0 to 8,388,607"),
    UNKNOWN("********", 1, 0xFFFFFF, "1 to 16,777,215", "Unknown protocol valid value range is 1-16,777,215");

    private String mMask;
    private int mMinimumValue;
    private int mMaximumValue;
    private String mValidRangeDescription;
    private String mValidRangeHelpText;

    private RadioFormat(String mask, int minimumValue, int maximumValue, String validRangeDescription, String validRangeHelpText) {
        this.mMask = mask;
        this.mMinimumValue = minimumValue;
        this.mMaximumValue = maximumValue;
        this.mValidRangeDescription = validRangeDescription;
        this.mValidRangeHelpText = validRangeHelpText;
    }

    public String getMask() {
        return this.mMask;
    }

    public int getMinimumValidValue() {
        return this.mMinimumValue;
    }

    public int getMaximumValidValue() {
        return this.mMaximumValue;
    }

    public boolean isValid(int value) {
        return this.getMinimumValidValue() <= value && value <= this.getMaximumValidValue();
    }

    public String getValidRangeDescription() {
        return this.mValidRangeDescription;
    }

    public String getValidRangeHelpText() {
        return this.mValidRangeHelpText;
    }

    public static RadioFormat get(Protocol protocol) {
        if (protocol == null) {
            return UNKNOWN;
        }
        switch (protocol) {
            case APCO25: {
                return APCO25;
            }
            case DMR: {
                return DMR;
            }
            case PASSPORT: {
                return PASSPORT;
            }
        }
        return UNKNOWN;
    }
}

