/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.radio;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.radio.RadioFormat;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;

public class Radio
extends AliasID
implements Comparable<Radio> {
    private Protocol mProtocol = Protocol.UNKNOWN;
    private int mValue;

    public Radio() {
    }

    public Radio(Protocol protocol, int value) {
        this.mProtocol = protocol;
        this.mValue = value;
    }

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    @JacksonXmlProperty(isAttribute=true, localName="value")
    public int getValue() {
        return this.mValue;
    }

    public void setValue(int value) {
        this.mValue = value;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="protocol")
    public Protocol getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.mProtocol = protocol;
        this.updateValueProperty();
    }

    @Override
    public boolean isValid() {
        if (this.mProtocol == null || this.mProtocol == Protocol.UNKNOWN) {
            return false;
        }
        RadioFormat radioFormat = RadioFormat.get(this.mProtocol);
        return radioFormat.getMinimumValidValue() <= this.mValue && this.mValue <= radioFormat.getMaximumValidValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Radio ID:").append(TalkgroupFormatter.format(this.mProtocol, this.mValue));
        sb.append(" Protocol:").append((Object)this.mProtocol);
        if (!this.isValid()) {
            sb.append(" **NOT VALID**");
        }
        return sb.toString();
    }

    @Override
    public boolean matches(AliasID id) {
        if (id instanceof Radio) {
            Radio tgid = (Radio)id;
            return this.getProtocol() == tgid.getProtocol() && this.getValue() == tgid.getValue();
        }
        return false;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.RADIO_ID;
    }

    @Override
    public int compareTo(Radio other) {
        if (other == null) {
            return -1;
        }
        if (this.getProtocol().equals((Object)other.getProtocol())) {
            return Integer.compare(this.getValue(), other.getValue());
        }
        return this.getProtocol().compareTo(other.getProtocol());
    }
}

