/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.github.dsheirer.alias.action.AliasAction;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.alias.id.priority.Priority;
import io.github.dsheirer.alias.id.record.Record;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JacksonXmlRootElement(localName="alias")
public class Alias {
    private static final Logger mLog = LoggerFactory.getLogger(Alias.class);
    private BooleanProperty mRecordable = new SimpleBooleanProperty();
    private BooleanProperty mStreamable = new SimpleBooleanProperty();
    private BooleanProperty mOverlap = new SimpleBooleanProperty();
    private IntegerProperty mColor = new SimpleIntegerProperty();
    private IntegerProperty mPriority = new SimpleIntegerProperty(100);
    private IntegerProperty mNonAudioIdentifierCount = new SimpleIntegerProperty();
    private StringProperty mAliasListName = new SimpleStringProperty();
    private StringProperty mGroup = new SimpleStringProperty();
    private StringProperty mIconName = new SimpleStringProperty();
    private StringProperty mName = new SimpleStringProperty();
    private ObservableList<AliasID> mAliasIDs = FXCollections.observableArrayList();
    private ObservableList<AliasAction> mAliasActions = FXCollections.observableArrayList();

    public Alias(String name) {
        this.mName.set((Object)name);
        this.mNonAudioIdentifierCount.bind((ObservableValue)Bindings.size((ObservableList)new FilteredList(this.mAliasIDs, aliasID -> aliasID != null && !aliasID.isAudioIdentifier())));
    }

    public Alias() {
        this(null);
    }

    @JsonIgnore
    public IntegerProperty nonAudioIdentifierCountProperty() {
        return this.mNonAudioIdentifierCount;
    }

    @JsonIgnore
    public IntegerProperty priorityProperty() {
        return this.mPriority;
    }

    @JsonIgnore
    public BooleanProperty overlapProperty() {
        return this.mOverlap;
    }

    @JsonIgnore
    public BooleanProperty recordableProperty() {
        return this.mRecordable;
    }

    @JsonIgnore
    public BooleanProperty streamableProperty() {
        return this.mStreamable;
    }

    @JsonIgnore
    public StringProperty aliasListNameProperty() {
        return this.mAliasListName;
    }

    @JsonIgnore
    public StringProperty groupProperty() {
        return this.mGroup;
    }

    @JsonIgnore
    public StringProperty nameProperty() {
        return this.mName;
    }

    @JsonIgnore
    public IntegerProperty colorProperty() {
        return this.mColor;
    }

    @JsonIgnore
    public StringProperty iconNameProperty() {
        return this.mIconName;
    }

    @JsonIgnore
    public ObservableList<AliasID> aliasIds() {
        return this.mAliasIDs;
    }

    @JsonIgnore
    public ObservableList<AliasAction> aliasActions() {
        return this.mAliasActions;
    }

    public String toString() {
        return this.getName();
    }

    @JacksonXmlProperty(isAttribute=true, localName="name")
    public String getName() {
        return (String)this.mName.get();
    }

    public void setName(String name) {
        this.mName.set((Object)name);
    }

    @JacksonXmlProperty(isAttribute=true, localName="list")
    public String getAliasListName() {
        return (String)this.mAliasListName.get();
    }

    public void setAliasListName(String aliasListName) {
        this.mAliasListName.set((Object)aliasListName);
    }

    @JsonIgnore
    public boolean matchesAliasList(String aliasList) {
        boolean isEmptyThis;
        boolean isEmptyArgument = aliasList == null || aliasList.isEmpty() || aliasList.contentEquals("(No Alias List)");
        boolean bl = isEmptyThis = this.getAliasListName() == null || this.getAliasListName().isEmpty();
        if (isEmptyArgument && isEmptyThis) {
            return true;
        }
        return !isEmptyArgument && !isEmptyThis && aliasList.contentEquals(this.getAliasListName());
    }

    public boolean hasList() {
        return this.mAliasListName.get() != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="group")
    public String getGroup() {
        return (String)this.mGroup.get();
    }

    public void setGroup(String group) {
        this.mGroup.set((Object)group);
    }

    public boolean hasGroup() {
        return this.mGroup.get() != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="color")
    public int getColor() {
        return this.mColor.get();
    }

    @JsonIgnore
    public String getColorHex() {
        return String.format("#%06X", 0xFFFFFF & this.mColor.get());
    }

    public void setColor(int color) {
        this.mColor.set(color);
    }

    @JsonIgnore
    public Color getDisplayColor() {
        return new Color(this.getColor());
    }

    @JacksonXmlProperty(isAttribute=true, localName="iconName")
    public String getIconName() {
        return (String)this.mIconName.get();
    }

    public void setIconName(String iconName) {
        this.mIconName.set((Object)iconName);
    }

    @JacksonXmlProperty(isAttribute=false, localName="id")
    public List<AliasID> getAliasIdentifiers() {
        return this.mAliasIDs;
    }

    public void setAliasIdentifiers(List<AliasID> id) {
        this.mAliasIDs.clear();
        for (AliasID aliasID : id) {
            this.addAliasID(aliasID);
        }
    }

    public void addAliasID(AliasID id) {
        this.mAliasIDs.add((Object)id);
        this.validate();
        this.updateOverlapBinding();
    }

    public void removeAliasID(AliasID id) {
        if (id != null) {
            this.mAliasIDs.remove((Object)id);
            this.validate();
            this.updateOverlapBinding();
        }
    }

    @JacksonXmlProperty(isAttribute=false, localName="action")
    public List<AliasAction> getAliasActions() {
        return this.mAliasActions;
    }

    public void setAliasActions(List<AliasAction> actions) {
        this.mAliasActions.setAll(actions);
    }

    public void addAliasAction(AliasAction action) {
        this.mAliasActions.add((Object)action);
    }

    public void removeAliasAction(AliasAction action) {
        this.mAliasActions.remove((Object)action);
    }

    public boolean hasActions() {
        return !this.mAliasActions.isEmpty();
    }

    private void updatePriority() {
        for (AliasID aliasID : this.mAliasIDs) {
            if (!(aliasID instanceof Priority)) continue;
            this.mPriority.set(((Priority)aliasID).getPriority());
            return;
        }
        this.mPriority.set(100);
    }

    private void updateOverlapBinding() {
        this.mOverlap.unbind();
        BooleanBinding binding = new SimpleBooleanProperty(true).not();
        for (AliasID aliasID : this.mAliasIDs) {
            binding = binding.or((ObservableBooleanValue)aliasID.overlapProperty());
        }
        this.mOverlap.bind((ObservableValue)binding);
    }

    private void updateRecordable() {
        for (AliasID aliasID : this.mAliasIDs) {
            if (!(aliasID instanceof Record)) continue;
            this.mRecordable.set(true);
            return;
        }
        this.mRecordable.set(false);
    }

    private void updateStreamable() {
        for (AliasID aliasID : this.mAliasIDs) {
            if (!(aliasID instanceof BroadcastChannel)) continue;
            this.mStreamable.set(true);
            return;
        }
        this.mStreamable.set(false);
    }

    public void validate() {
        this.updatePriority();
        this.updateRecordable();
        this.updateStreamable();
    }

    @JsonIgnore
    public int getPlaybackPriority() {
        for (AliasID id : this.mAliasIDs) {
            if (id.getType() != AliasIDType.PRIORITY) continue;
            return ((Priority)id).getPriority();
        }
        return 100;
    }

    public boolean hasCallPriority() {
        for (AliasID id : this.mAliasIDs) {
            if (id.getType() != AliasIDType.PRIORITY) continue;
            return true;
        }
        return false;
    }

    public void setCallPriority(int priority) {
        AliasID priorityID = null;
        for (AliasID aliasID : this.mAliasIDs) {
            if (!(aliasID instanceof Priority)) continue;
            priorityID = aliasID;
        }
        this.removeAliasID(priorityID);
        if (priority == -1 || 1 <= priority && priority < 100) {
            this.addAliasID(new Priority(priority));
        }
    }

    @JsonIgnore
    public boolean isRecordable() {
        return this.mRecordable.get();
    }

    public void setRecordable(boolean recordable) {
        AliasID recordID = null;
        for (AliasID aliasID : this.mAliasIDs) {
            if (!(aliasID instanceof Record)) continue;
            recordID = aliasID;
        }
        this.removeAliasID(recordID);
        if (recordable) {
            this.addAliasID(new Record());
        }
    }

    @JsonIgnore
    public boolean isStreamable() {
        return this.mStreamable.get();
    }

    @JsonIgnore
    public Set<BroadcastChannel> getBroadcastChannels() {
        TreeSet<BroadcastChannel> broadcastChannels = new TreeSet<BroadcastChannel>();
        for (AliasID id : this.getAliasIdentifiers()) {
            if (id.getType() != AliasIDType.BROADCAST_CHANNEL) continue;
            broadcastChannels.add((BroadcastChannel)id);
        }
        return broadcastChannels;
    }

    public boolean hasBroadcastChannel(String channel) {
        if (channel == null || channel.isEmpty()) {
            return false;
        }
        for (AliasID id : this.getAliasIdentifiers()) {
            BroadcastChannel broadcastChannel;
            if (!(id instanceof BroadcastChannel) || (broadcastChannel = (BroadcastChannel)id).getChannelName() == null || !broadcastChannel.getChannelName().contentEquals(channel)) continue;
            return true;
        }
        return false;
    }

    public void removeBroadcastChannel(String channel) {
        if (channel == null || channel.isEmpty()) {
            return;
        }
        ArrayList<AliasID> toRemove = new ArrayList<AliasID>();
        for (AliasID aliasID : this.getAliasIdentifiers()) {
            if (!(aliasID instanceof BroadcastChannel) || !((BroadcastChannel)aliasID).getChannelName().contentEquals(channel)) continue;
            toRemove.add(aliasID);
        }
        for (AliasID aliasID : toRemove) {
            this.removeAliasID(aliasID);
        }
    }

    public void removeAllBroadcastChannels() {
        ArrayList<AliasID> toRemove = new ArrayList<AliasID>();
        for (AliasID aliasID : this.mAliasIDs) {
            if (!(aliasID instanceof BroadcastChannel)) continue;
            toRemove.add(aliasID);
        }
        for (AliasID aliasID : toRemove) {
            this.removeAliasID(aliasID);
        }
    }

    public void removeNonAudioIdentifiers() {
        Iterator it = this.mAliasIDs.iterator();
        while (it.hasNext()) {
            if (((AliasID)it.next()).isAudioIdentifier()) continue;
            it.remove();
        }
    }

    public void removeAllActions() {
        this.mAliasActions.clear();
    }

    /*
     * Exception decompiling
     */
    public static Callback<Alias, Observable[]> extractor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

