#!/usr/bin/env bash
###############################################################################
#
# Bash Remediation Script for McAfee VirusScan Enterprise for Linux (VSEL) STIG
#
# Profile Description:
# The McAfee VirusScan Enterprise for Linux software provides a realtime virus scanner for Linux systems.
#
# Profile ID:  stig
# Benchmark ID:  VSEL
# Benchmark Version:  0.1.60
# XCCDF Version:  1.1
#
# This file was generated by OpenSCAP 1.3.5 using:
# $ oscap xccdf generate fix --profile stig --fix-type bash xccdf-file.xml
#
# This Bash Remediation Script is generated from an OpenSCAP profile without preliminary evaluation.
# It attempts to fix every selected rule, even if the system is already compliant.
#
# How to apply this Bash Remediation Script:
# $ sudo ./remediation-script.sh
#
###############################################################################

###############################################################################
# BEGIN fix (1 / 39) for 'dats_auto_update'
###############################################################################
(>&2 echo "Remediating rule 1/39: 'dats_auto_update'")
(>&2 echo "FIX FOR THIS RULE 'dats_auto_update' IS MISSING!")

# END fix for 'dats_auto_update'

###############################################################################
# BEGIN fix (2 / 39) for 'dats_updated'
###############################################################################
(>&2 echo "Remediating rule 2/39: 'dats_updated'")
(>&2 echo "FIX FOR THIS RULE 'dats_updated' IS MISSING!")

# END fix for 'dats_updated'

###############################################################################
# BEGIN fix (3 / 39) for 'restricted_user'
###############################################################################
(>&2 echo "Remediating rule 3/39: 'restricted_user'")
(>&2 echo "FIX FOR THIS RULE 'restricted_user' IS MISSING!")

# END fix for 'restricted_user'

###############################################################################
# BEGIN fix (4 / 39) for 'scanned_media'
###############################################################################
(>&2 echo "Remediating rule 4/39: 'scanned_media'")
(>&2 echo "FIX FOR THIS RULE 'scanned_media' IS MISSING!")

# END fix for 'scanned_media'

###############################################################################
# BEGIN fix (5 / 39) for 'updates_source'
###############################################################################
(>&2 echo "Remediating rule 5/39: 'updates_source'")
(>&2 echo "FIX FOR THIS RULE 'updates_source' IS MISSING!")

# END fix for 'updates_source'

###############################################################################
# BEGIN fix (6 / 39) for 'virus_notification'
###############################################################################
(>&2 echo "Remediating rule 6/39: 'virus_notification'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^notifications.virusDetected.active")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^notifications.virusDetected.active\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^notifications.virusDetected.active\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'virus_notification'

###############################################################################
# BEGIN fix (7 / 39) for 'web_client_disabled'
###############################################################################
(>&2 echo "Remediating rule 7/39: 'web_client_disabled'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.disableCltWebUI")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.disableCltWebUI\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.disableCltWebUI\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'web_client_disabled'

###############################################################################
# BEGIN fix (8 / 39) for 'web_client_firewalled'
###############################################################################
(>&2 echo "Remediating rule 8/39: 'web_client_firewalled'")
(>&2 echo "FIX FOR THIS RULE 'web_client_firewalled' IS MISSING!")

# END fix for 'web_client_firewalled'

###############################################################################
# BEGIN fix (9 / 39) for 'oas_action_app_primary'
###############################################################################
(>&2 echo "Remediating rule 9/39: 'oas_action_app_primary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.action.App.primary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Clean"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.action.App.primary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.action.App.primary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_action_app_primary'

###############################################################################
# BEGIN fix (10 / 39) for 'oas_action_app_secondary'
###############################################################################
(>&2 echo "Remediating rule 10/39: 'oas_action_app_secondary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.action.App.secondary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Quarantine"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.action.App.secondary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.action.App.secondary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_action_app_secondary'

###############################################################################
# BEGIN fix (11 / 39) for 'oas_action_default_primary'
###############################################################################
(>&2 echo "Remediating rule 11/39: 'oas_action_default_primary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.action.Default.primary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Clean"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.action.Default.primary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.action.Default.primary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_action_default_primary'

###############################################################################
# BEGIN fix (12 / 39) for 'oas_action_default_secondary'
###############################################################################
(>&2 echo "Remediating rule 12/39: 'oas_action_default_secondary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.action.Default.secondary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Quarantine"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.action.Default.secondary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.action.Default.secondary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_action_default_secondary'

###############################################################################
# BEGIN fix (13 / 39) for 'oas_action_error'
###############################################################################
(>&2 echo "Remediating rule 13/39: 'oas_action_error'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.action.error")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Block"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.action.error\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.action.error\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_action_error'

###############################################################################
# BEGIN fix (14 / 39) for 'oas_action_timeout'
###############################################################################
(>&2 echo "Remediating rule 14/39: 'oas_action_timeout'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.action.timeout")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Pass"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.action.timeout\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.action.timeout\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_action_timeout'

###############################################################################
# BEGIN fix (15 / 39) for 'oas_allFiles'
###############################################################################
(>&2 echo "Remediating rule 15/39: 'oas_allFiles'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.allFiles")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.allFiles\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.allFiles\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_allFiles'

###############################################################################
# BEGIN fix (16 / 39) for 'oas_decompArchive'
###############################################################################
(>&2 echo "Remediating rule 16/39: 'oas_decompArchive'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.decompArchive")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.decompArchive\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.decompArchive\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_decompArchive'

###############################################################################
# BEGIN fix (17 / 39) for 'oas_enabled'
###############################################################################
(>&2 echo "Remediating rule 17/39: 'oas_enabled'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.oasEnabled")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.oasEnabled\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.oasEnabled\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_enabled'

###############################################################################
# BEGIN fix (18 / 39) for 'oas_exclusions'
###############################################################################
(>&2 echo "Remediating rule 18/39: 'oas_exclusions'")
(>&2 echo "FIX FOR THIS RULE 'oas_exclusions' IS MISSING!")

# END fix for 'oas_exclusions'

###############################################################################
# BEGIN fix (19 / 39) for 'oas_heuristicAnalysis'
###############################################################################
(>&2 echo "Remediating rule 19/39: 'oas_heuristicAnalysis'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.heuristicAnalysis")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.heuristicAnalysis\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.heuristicAnalysis\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_heuristicAnalysis'

###############################################################################
# BEGIN fix (20 / 39) for 'oas_macroAnalysis'
###############################################################################
(>&2 echo "Remediating rule 20/39: 'oas_macroAnalysis'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.macroAnalysis")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.macroAnalysis\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.macroAnalysis\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_macroAnalysis'

###############################################################################
# BEGIN fix (21 / 39) for 'oas_program'
###############################################################################
(>&2 echo "Remediating rule 21/39: 'oas_program'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.program")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.program\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.program\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_program'

###############################################################################
# BEGIN fix (22 / 39) for 'oas_scanMaxTmo'
###############################################################################
(>&2 echo "Remediating rule 22/39: 'oas_scanMaxTmo'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.scanMaxTmo")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "45"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.scanMaxTmo\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.scanMaxTmo\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_scanMaxTmo'

###############################################################################
# BEGIN fix (23 / 39) for 'oas_scanNWFiles'
###############################################################################
(>&2 echo "Remediating rule 23/39: 'oas_scanNWFiles'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.scanNWFiles")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.scanNWFiles\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.scanNWFiles\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_scanNWFiles'

###############################################################################
# BEGIN fix (24 / 39) for 'oas_scanOnRead'
###############################################################################
(>&2 echo "Remediating rule 24/39: 'oas_scanOnRead'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.scanOnRead")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.scanOnRead\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.scanOnRead\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_scanOnRead'

###############################################################################
# BEGIN fix (25 / 39) for 'oas_scanOnWrite'
###############################################################################
(>&2 echo "Remediating rule 25/39: 'oas_scanOnWrite'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/nailsd.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.OAS.scanOnWrite")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.OAS.scanOnWrite\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.OAS.scanOnWrite\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'oas_scanOnWrite'

###############################################################################
# BEGIN fix (26 / 39) for 'ods_action_app_primary'
###############################################################################
(>&2 echo "Remediating rule 26/39: 'ods_action_app_primary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.action.App.primary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Clean"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.action.App.primary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.action.App.primary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_action_app_primary'

###############################################################################
# BEGIN fix (27 / 39) for 'ods_action_app_secondary'
###############################################################################
(>&2 echo "Remediating rule 27/39: 'ods_action_app_secondary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.action.App.secondary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Quarantine"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.action.App.secondary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.action.App.secondary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_action_app_secondary'

###############################################################################
# BEGIN fix (28 / 39) for 'ods_action_default_primary'
###############################################################################
(>&2 echo "Remediating rule 28/39: 'ods_action_default_primary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.action.Default.primary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Clean"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.action.Default.primary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.action.Default.primary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_action_default_primary'

###############################################################################
# BEGIN fix (29 / 39) for 'ods_action_default_secondary'
###############################################################################
(>&2 echo "Remediating rule 29/39: 'ods_action_default_secondary'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.action.Default.secondary")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "Quarantine"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.action.Default.secondary\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.action.Default.secondary\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_action_default_secondary'

###############################################################################
# BEGIN fix (30 / 39) for 'ods_allFiles'
###############################################################################
(>&2 echo "Remediating rule 30/39: 'ods_allFiles'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.allFiles")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.allFiles\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.allFiles\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_allFiles'

###############################################################################
# BEGIN fix (31 / 39) for 'ods_decompArchive'
###############################################################################
(>&2 echo "Remediating rule 31/39: 'ods_decompArchive'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.decompArchive")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.decompArchive\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.decompArchive\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_decompArchive'

###############################################################################
# BEGIN fix (32 / 39) for 'ods_enabled'
###############################################################################
(>&2 echo "Remediating rule 32/39: 'ods_enabled'")
(>&2 echo "FIX FOR THIS RULE 'ods_enabled' IS MISSING!")

# END fix for 'ods_enabled'

###############################################################################
# BEGIN fix (33 / 39) for 'ods_exclusions'
###############################################################################
(>&2 echo "Remediating rule 33/39: 'ods_exclusions'")
(>&2 echo "FIX FOR THIS RULE 'ods_exclusions' IS MISSING!")

# END fix for 'ods_exclusions'

###############################################################################
# BEGIN fix (34 / 39) for 'ods_extensions'
###############################################################################
(>&2 echo "Remediating rule 34/39: 'ods_extensions'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"

if  ! grep -q extensions.mode "$NAILS_CONFIG_FILE"; then
	sed -i '$a nailsd.profile.ODS_default.filter.extensions.mode: all' "$NAILS_CONFIG_FILE"

else
	# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "extensions.mode")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "all"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "extensions.mode\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/extensions.mode\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi
fi

# END fix for 'ods_extensions'

###############################################################################
# BEGIN fix (35 / 39) for 'ods_heuristicAnalysis'
###############################################################################
(>&2 echo "Remediating rule 35/39: 'ods_heuristicAnalysis'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.heuristicAnalysis")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.heuristicAnalysis\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.heuristicAnalysis\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_heuristicAnalysis'

###############################################################################
# BEGIN fix (36 / 39) for 'ods_macroAnalysis'
###############################################################################
(>&2 echo "Remediating rule 36/39: 'ods_macroAnalysis'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.macroAnalysis")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.macroAnalysis\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.macroAnalysis\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_macroAnalysis'

###############################################################################
# BEGIN fix (37 / 39) for 'ods_mime'
###############################################################################
(>&2 echo "Remediating rule 37/39: 'ods_mime'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.mime")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.mime\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.mime\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_mime'

###############################################################################
# BEGIN fix (38 / 39) for 'ods_program'
###############################################################################
(>&2 echo "Remediating rule 38/39: 'ods_program'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.program")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.program\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.program\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_program'

###############################################################################
# BEGIN fix (39 / 39) for 'ods_scanNWFiles_local'
###############################################################################
(>&2 echo "Remediating rule 39/39: 'ods_scanNWFiles_local'")


NAILS_CONFIG_FILE="/var/opt/NAI/LinuxShield/etc/ods.cfg"
# Test if the config_file is a symbolic link. If so, use --follow-symlinks with sed.
# Otherwise, regular sed command will do.
sed_command=('sed' '-i')
if test -L "$NAILS_CONFIG_FILE"; then
    sed_command+=('--follow-symlinks')
fi

# Strip any search characters in the key arg so that the key can be replaced without
# adding any search characters to the config file.
stripped_key=$(sed 's/[\^=\$,;+]*//g' <<< "^nailsd.profile.ODS.scanNWFiles")

# shellcheck disable=SC2059
printf -v formatted_output "%s: %s" "$stripped_key" "true"

# If the key exists, change it. Otherwise, add it to the config_file.
# We search for the key string followed by a word boundary (matched by \>),
# so if we search for 'setting', 'setting2' won't match.
if LC_ALL=C grep -q -m 1 -i -e "^nailsd.profile.ODS.scanNWFiles\\>" "$NAILS_CONFIG_FILE"; then
    "${sed_command[@]}" "s/^nailsd.profile.ODS.scanNWFiles\\>.*/$formatted_output/gi" "$NAILS_CONFIG_FILE"
else
    # \n is precaution for case where file ends without trailing newline
    
    printf '%s\n' "$formatted_output" >> "$NAILS_CONFIG_FILE"
fi

# END fix for 'ods_scanNWFiles_local'

