/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.webapp;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public final class ServletConfigDefaultsFacade
implements ServletConfig {
    private final ServletConfig config;
    private final Map<String, String> defaults;

    public ServletConfigDefaultsFacade(ServletConfig config, Map<String, String> defaults) {
        this.config = config;
        this.defaults = defaults;
    }

    public String getServletName() {
        return this.config.getServletName();
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public String getInitParameter(String name) {
        String parameter = this.config.getInitParameter(name);
        if (parameter == null) {
            parameter = this.config.getServletContext().getInitParameter(name);
        }
        if (parameter == null) {
            parameter = this.defaults.get(name);
        }
        return parameter;
    }

    public Enumeration getInitParameterNames() {
        HashSet result = Sets.newHashSet();
        Iterators.addAll(result, (Iterator)((Object)this.defaults.keySet()));
        Iterators.addAll(result, Iterators.forEnumeration(this.config.getInitParameterNames()));
        Iterators.addAll(result, Iterators.forEnumeration(this.config.getServletContext().getInitParameterNames()));
        return Iterators.asEnumeration(result.iterator());
    }
}

