/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.webapp.taglib.HtmlComponentTagBase;
import org.richfaces.component.UIPanelMenuGroup;

public abstract class PanelMenuGroupTagBase
extends HtmlComponentTagBase {
    private boolean _setExpandedSet = false;
    private ValueExpression _value = null;

    private void logValueDeprecation(ValueExpression value) {
        FacesContext facesContext = this.getFacesContext();
        facesContext.getExternalContext().log("expanded attribute has been already set for component with id: " + this.getId() + "[" + value.getExpressionString() + "]. value attribute is deprecated and thus has been dropped!");
    }

    public void setExpanded(ValueExpression value) {
        if (!this._setExpandedSet && this._value != null) {
            this.logValueDeprecation(value);
        }
        this._value = value;
        this._setExpandedSet = true;
    }

    public void setValue(ValueExpression value) {
        if (!this._setExpandedSet) {
            this._value = value;
        } else {
            this.logValueDeprecation(value);
        }
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        UIPanelMenuGroup panelMenu = (UIPanelMenuGroup)component;
        if (this._value != null) {
            if (this._value.isLiteralText()) {
                try {
                    panelMenu.setExpanded(Boolean.parseBoolean(this._value.getExpressionString()));
                }
                catch (ELException e) {
                    throw new FacesException(e);
                }
            } else {
                component.setValueExpression("value", this._value);
            }
        } else {
            panelMenu.setExpanded(false);
        }
    }

    public void release() {
        super.release();
        this._setExpandedSet = false;
        this._value = null;
    }
}

