/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.optimizer.faces.CurrentResourceContext;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;

public class JavaScriptPackagingProcessor
implements ResourceProcessor {
    private Charset charset;

    public JavaScriptPackagingProcessor(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".js");
    }

    @Override
    public void process(String outputName, ByteSource byteSource, ByteSink byteSink, boolean closeAtFinish) throws IOException {
        this.process(outputName, byteSource.openStream(), byteSink.openStream(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String outputName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        Reader reader = null;
        Writer writer = null;
        try {
            reader = new InputStreamReader(in, this.charset);
            writer = new OutputStreamWriter(out, this.charset);
            CurrentResourceContext crc = CurrentResourceContext.getInstance(FacesContext.getCurrentInstance());
            writer.write(String.format("// resource: %s\n", ResourceKey.create(crc.getResource())));
            writer.flush();
            ByteStreams.copy(in, out);
            if (!closeAtFinish) {
                writer.write(";");
            }
            writer.write("\n\n");
            writer.flush();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
            if (closeAtFinish) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            } else {
                writer.flush();
            }
        }
    }
}

