/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.concurrent.atomic.AtomicReference;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ResourceTracker;
import org.richfaces.resource.external.ResourceTrackerForMojarra;
import org.richfaces.resource.external.ResourceTrackerForMyFaces;

public class ResourceTrackerImpl
implements ResourceTracker {
    private static final Logger LOG = RichfacesLogger.RESOURCE.getLogger();
    private static final String MYFACES_RESOURCE_UTILS_CLASS = "org.apache.myfaces.shared.renderkit.html.util.ResourceUtils";
    private static final String WEBSPHERE_BUNDLED_MYFACES_RESOURCE_UTILS_CLASS = "org.apache.myfaces.shared_impl.renderkit.html.util.ResourceUtils";
    private static final String[] MYFACES_RESOURCE_UTILS_CLASSES = new String[]{"org.apache.myfaces.shared.renderkit.html.util.ResourceUtils", "org.apache.myfaces.shared_impl.renderkit.html.util.ResourceUtils"};
    private AtomicReference<ResourceTracker> externalResourceTracker = new AtomicReference();

    @Override
    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        return this.getImplementation().isResourceRenderered(facesContext, resourceKey);
    }

    @Override
    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        this.getImplementation().markResourceRendered(facesContext, resourceKey);
    }

    private ResourceTracker getImplementation() {
        ResourceTracker tracker = this.externalResourceTracker.get();
        if (tracker == null) {
            Class<?> myfacesResUtilClass = null;
            boolean myFacesInUse = false;
            for (String myFacesResourceUtilsClass : MYFACES_RESOURCE_UTILS_CLASSES) {
                try {
                    ClassLoader cl = this.getClass().getClassLoader();
                    myfacesResUtilClass = cl.loadClass(myFacesResourceUtilsClass);
                    Class<?> factoryClass = cl.loadClass("org.apache.myfaces.context.FacesContextFactoryImpl");
                    Object factory = FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
                    myFacesInUse = factoryClass.isInstance(factory);
                    break;
                }
                catch (Exception e) {
                    LOG.debug("could not load myfaces resource utils class: " + myFacesResourceUtilsClass, e);
                }
            }
            if (myFacesInUse) {
                this.externalResourceTracker.compareAndSet(null, new ResourceTrackerForMyFaces(myfacesResUtilClass));
            } else {
                this.externalResourceTracker.compareAndSet(null, new ResourceTrackerForMojarra());
            }
            tracker = this.externalResourceTracker.get();
        }
        return tracker;
    }
}

