/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import java.util.Map;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.richfaces.JsfVersion;

public final class ViewStateIdUtils {
    private static final String VIEW_STATE_COUNTER_KEY = "org.richfaces.ViewStateCounterKey";
    private static final int VIEW_STATE_NUMBER_BASE = 0;

    private ViewStateIdUtils() {
    }

    public static String getViewStateId(FacesContext context) {
        if (JsfVersion.getCurrent().isCompliantWith(JsfVersion.JSF_2_2)) {
            return ViewStateIdUtils.generateUniqueViewStateId(context);
        }
        return "javax.faces.ViewState";
    }

    private static String generateUniqueViewStateId(FacesContext context) {
        String result = null;
        Map<Object, Object> contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get(VIEW_STATE_COUNTER_KEY);
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar(context);
        UIViewRoot root = context.getViewRoot();
        result = root.getContainerClientId(context) + sep + "javax.faces.ViewState" + sep + counter;
        counter = counter + 1;
        contextAttrs.put(VIEW_STATE_COUNTER_KEY, counter);
        return result;
    }
}

