/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.AnimationResource;
import org.ajax4jsf.resource.ImageRenderer;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.renderkit.html.images.ColorUtils;
import org.richfaces.skin.SkinFactory;

public class ProgressBarAnimatedBg
extends AnimationResource {
    private static int NUMBER_OF_FRAMES = 12;
    private BufferedImage mainStage;
    private Dimension frameSize = new Dimension(24, 48);
    private Color progressbarBasicColor;
    private Color progressbarSpiralColor;
    private Color progressbarBackgroundColor;
    private Color progressbarShadowStartColor;
    private Color progressbarShadowEndColor;

    protected Dimension getFrameSize(ResourceContext resourceContext) {
        return this.frameSize;
    }

    public boolean isCacheable(ResourceContext ctx) {
        return true;
    }

    protected int getRepeat() {
        return 0;
    }

    protected int getNumberOfFrames() {
        return NUMBER_OF_FRAMES;
    }

    protected void paint(ResourceContext context, Graphics2D g2d, int frameIndex) {
        this.restoreData(context);
        this.mainStage = this.createMainStage(context);
        BufferedImage frame = this.mainStage.getSubimage(0, 48 - frameIndex * 2, this.frameSize.width, this.frameSize.height);
        g2d.drawImage(frame, null, null);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.progressbarShadowStartColor, 0.0f, 7.0f, this.progressbarShadowEndColor));
        g2d.fillRect(0, 0, this.frameSize.width, 7);
    }

    private BufferedImage createMainStage(ResourceContext ctx) {
        this.progressbarBackgroundColor = this.progressbarBasicColor;
        this.progressbarSpiralColor = ColorUtils.adjustLightness(this.progressbarBasicColor, 0.2f);
        this.progressbarShadowStartColor = ColorUtils.overwriteAlpha(ColorUtils.adjustLightness(this.progressbarBasicColor, 0.7f), 0.6f);
        this.progressbarShadowEndColor = ColorUtils.overwriteAlpha(ColorUtils.adjustLightness(this.progressbarBasicColor, 0.3f), 0.6f);
        BufferedImage retVal = ((ImageRenderer)this.getRenderer(ctx)).createImage(this.frameSize.width, this.frameSize.height * 2);
        Graphics g = retVal.getGraphics();
        g.setColor(this.progressbarBackgroundColor);
        g.fillRect(0, 0, this.frameSize.width, this.frameSize.height * 2);
        g.setColor(this.progressbarSpiralColor);
        for (int k : new int[]{-24, 0, 24, 48, 72}) {
            g.fillPolygon(new int[]{0, 24, 24, 0}, new int[]{24 + k, k, 12 + k, 36 + k}, 4);
        }
        g.dispose();
        return retVal;
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        byte[] retVal = new byte[3];
        this.progressbarBasicColor = this.getColorValueParameter(context, "selectControlColor");
        new Zipper2(retVal).addColor(this.progressbarBasicColor);
        return retVal;
    }

    protected Object deserializeData(byte[] objectArray) {
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            this.progressbarBasicColor = zipper2.nextColor();
        }
        return objectArray;
    }

    private Color getColorValueParameter(FacesContext context, String name) {
        Color retVal = null;
        String color = (String)SkinFactory.getInstance().getSkin(context).getParameter(context, name);
        if (null == color || "".equals(color.trim())) {
            color = (String)SkinFactory.getInstance().getDefaultSkin(context).getParameter(context, name);
        }
        if (null != color && !"".equals(color.trim())) {
            retVal = HtmlColor.decode(color);
        }
        return retVal;
    }
}

