/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.style.CSSFormat;
import org.richfaces.component.UISeparator;
import org.richfaces.renderkit.html.images.BevelSeparatorImage;
import org.richfaces.renderkit.html.images.SimpleSeparatorImage;

public class SeparatorRendererBase
extends HeaderResourcesRendererBase {
    public static final String IMAGE_CLASS_BEVEL = "rich-separator-image-bevel";
    public static final String IMAGE_CLASS_SIMPLE = "rich-separator-image-simple";
    public static final int DEFAULT_HEIGHT = 6;
    public static final String LINE_TYPE_NONE = "none";
    public static final String LINE_TYPE_BEVEL = "beveled";
    public static final String LINE_TYPE_DOUBLE = "double";
    public static final String LINE_TYPE_DOTTED = "dotted";
    public static final String LINE_TYPE_DASHED = "dashed";
    public static final String LINE_TYPE_SOLID = "solid";
    public static final String[] SUPPORTED_TYPES = new String[]{"beveled", "dashed", "dotted", "double", "solid"};

    private String getCSSDimension(UIComponent component, String attributeName) {
        String height;
        Object hO = component.getAttributes().get(attributeName);
        if (hO == null) {
            return null;
        }
        if (hO instanceof String) {
            height = (String)hO;
            if (height.trim().length() == 0) {
                return null;
            }
        } else {
            height = hO.toString();
        }
        if (height.trim().length() == 0) {
            return height;
        }
        return this.getUtils().encodePctOrPx(height);
    }

    protected Class getComponentClass() {
        return UISeparator.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean isSupportedLineType(String lineType) {
        for (int i = 0; i < SUPPORTED_TYPES.length; ++i) {
            if (!lineType.equalsIgnoreCase(SUPPORTED_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    public String backgroundImage(FacesContext context, UIComponent component) throws IOException {
        UISeparator separator = (UISeparator)component;
        String lineType = separator.getLineType();
        if (LINE_TYPE_NONE.equals(lineType)) {
            return LINE_TYPE_NONE;
        }
        if (lineType == null || lineType.trim().length() == 0 || !this.isSupportedLineType(lineType)) {
            lineType = LINE_TYPE_BEVEL;
        }
        int h = 6;
        String height = this.getCSSDimension(component, "height");
        if (null != height) {
            if (height.trim().endsWith("%")) {
                throw new FacesException("It is not allowed to set height of separator in percent (component " + component.getId() + ")!");
            }
            h = HtmlDimensions.decode(height).intValue();
        }
        if (lineType.equalsIgnoreCase(LINE_TYPE_BEVEL) && h < 3) {
            lineType = LINE_TYPE_SOLID;
        }
        String uri = null;
        uri = lineType.equalsIgnoreCase(LINE_TYPE_BEVEL) ? this.getResource(BevelSeparatorImage.class.getName()).getUri(context, component) : this.getResource(SimpleSeparatorImage.class.getName()).getUri(context, component);
        if (uri != null) {
            uri = CSSFormat.url(uri);
        }
        return uri;
    }

    public String getStyle(FacesContext context, UIComponent component) throws IOException {
        String width;
        StringBuffer buff = new StringBuffer();
        String height = this.getCSSDimension(component, "height");
        if (null != height) {
            buff.append("height: " + height + "; ");
        }
        if (null != (width = this.getCSSDimension(component, "width"))) {
            buff.append("width: " + width + "; ");
        }
        buff.append("background-image: " + this.backgroundImage(context, component) + "; ");
        buff.append(component.getAttributes().get("style"));
        return buff.toString();
    }
}

