/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.ImageCacheScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIPanelBar;
import org.richfaces.component.UIPanelBarItem;
import org.richfaces.event.SwitchablePanelSwitchEvent;
import org.richfaces.renderkit.ScriptOptions;

public abstract class PanelBarRendererBase
extends HeaderResourcesRendererBase {
    public static final String PANEL_BAR_RESOURCES = "PANEL_BAR_RESOURCES";
    public static final String EXPANDED_ATTR = "expanded";
    private final InternetResource[] scripts = new InternetResource[]{new AjaxScript(), new PrototypeScript(), new ImageCacheScript(), this.getResource("/org/richfaces/renderkit/html/scripts/browser_info.js"), this.getResource("/org/richfaces/renderkit/html/scripts/utils.js"), this.getResource("scripts/panelbar.js")};

    protected InternetResource[] getScripts() {
        return this.scripts;
    }

    protected Class getComponentClass() {
        return UIPanelBar.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String expanded(FacesContext context, UIComponent component) throws IOException {
        UIPanelBar panelbar = (UIPanelBar)component;
        String value = (String)panelbar.getValue();
        ValueBinding valueBinding = panelbar.getValueBinding("selectedPanel");
        if (value != null && valueBinding == null) {
            return value;
        }
        Object selected = panelbar.getSelectedPanel();
        if (selected != null) {
            List<UIComponent> items = panelbar.getChildren();
            for (UIComponent comp : items) {
                UIPanelBarItem item;
                if (!(comp instanceof UIPanelBarItem) || !(item = (UIPanelBarItem)comp).getName().equals(selected)) continue;
                return item.getClientId(context);
            }
        }
        return "";
    }

    public String width(FacesContext context, UIComponent component) throws IOException {
        String width = (String)component.getAttributes().get("width");
        if (width == null || width.length() == 0) {
            width = "100%";
        }
        return "width: " + this.getUtils().encodePctOrPx(width) + ";";
    }

    public String height(FacesContext context, UIComponent component) throws IOException {
        String height = (String)component.getAttributes().get("height");
        if (height == null || height.length() == 0 || height.equals("100%")) {
            height = "100%";
        }
        return "height: " + this.getUtils().encodePctOrPx(height) + ";";
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = requestParameterMap.get(component.getClientId(context));
        if (value != null) {
            new SwitchablePanelSwitchEvent(component, value, null).queue();
        }
    }

    protected List getScriptPanelBarItems(FacesContext context, UIPanelBar panelBar) {
        ArrayList items = new ArrayList();
        JSReference id_ref = new JSReference("id");
        List<UIComponent> children = panelBar.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UIPanelBarItem) || !child.isRendered()) continue;
            HashMap<Object, Object> item = new HashMap<Object, Object>();
            UIPanelBarItem panelBarItem = (UIPanelBarItem)child;
            item.put(id_ref, panelBarItem.getClientId(context));
            Object enterScript = panelBarItem.getAttributes().get("onenter");
            Object leaveScript = panelBarItem.getAttributes().get("onleave");
            if (enterScript != null && !enterScript.equals("")) {
                JSFunctionDefinition onenter = new JSFunctionDefinition(new Object[0]);
                onenter.addParameter("event");
                onenter.addToBody(enterScript);
                item.put("onenter", onenter);
            } else {
                item.put("onenter", "");
            }
            if (leaveScript != null && !leaveScript.equals("")) {
                JSFunctionDefinition onleave = new JSFunctionDefinition(new Object[0]);
                onleave.addParameter("event");
                onleave.addToBody(leaveScript);
                item.put("onleave", onleave);
            } else {
                item.put("onleave", "");
            }
            items.add(item);
        }
        return items;
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIPanelBar) {
            UIPanelBar panelBar = (UIPanelBar)component;
            List items = this.getScriptPanelBarItems(context, panelBar);
            ScriptOptions options = new ScriptOptions(component);
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
            this.addHandlerOption(panelBar, options, "onitemchange");
            this.addHandlerOption(panelBar, options, "onitemchanged");
            options.addOption("onclick", panelBar.getAttributes().get("onclick"));
            options.addOption("mouseover", panelBar.getAttributes().get("onmouseover"));
            options.addOption("mouseout", panelBar.getAttributes().get("onmouseout"));
            options.addOption("mousemove", panelBar.getAttributes().get("onmousemove"));
            options.addOption("items", items);
            options.addOption("ajax", ajaxContext.isAjaxRequest());
            StringBuffer script = new StringBuffer();
            JSFunction function = new JSFunction("new Richfaces.PanelBar", new Object[0]);
            function.addParameter(panelBar.getClientId(context));
            function.addParameter(options);
            function.appendScript(script);
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", panelBar);
            writer.writeAttribute("type", "text/javascript", null);
            String outerScript = script.append(";").toString();
            writer.write(outerScript);
            writer.endElement("script");
        }
    }

    private void addHandlerOption(UIPanelBar component, ScriptOptions options, String handlerName) {
        Object changeScript = component.getAttributes().get(handlerName);
        if (changeScript != null && !changeScript.equals("")) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
            function.addParameter("event");
            function.addToBody(changeScript);
            options.addOption(handlerName, function);
        } else {
            options.addOption(handlerName, "");
        }
    }
}

