/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.RichMessageLevelHelper;
import org.richfaces.component.UIRichMessage;
import org.richfaces.renderkit.RichMessageBaseRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRichMessageRenderer
extends RichMessageBaseRenderer {
    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        Iterator<FacesMessage> msgIter = null;
        UIRichMessage msgComponent = (UIRichMessage)component;
        String forClientId = msgComponent.getFor();
        if (forClientId == null) {
            if (log.isErrorEnabled()) {
                log.error("'for' attribute cannot be null");
            }
        } else {
            msgIter = this.getMessageIterator(context, forClientId, msgComponent);
            writer.startElement("span", msgComponent);
            this.getUtils().writeAttribute(writer, "id", msgComponent.getClientId(context));
            if (!msgIter.hasNext() && msgComponent.isPassed()) {
                this.encodingUIContent(msgComponent, context, null);
            } else if (msgIter.hasNext()) {
                FacesMessage message = msgIter.next();
                this.encodingUIContent(msgComponent, context, message);
            }
            writer.endElement("span");
        }
    }

    protected void encodingUIContent(UIRichMessage uiMsg, FacesContext context, FacesMessage facesMsg) throws IOException {
        String[] levels;
        ResponseWriter writer = context.getResponseWriter();
        List<String> severenities = RichMessageLevelHelper.getSeverenities(uiMsg);
        List<String> acceptLevels = this.creatAcceptLevels(severenities.toArray(levels = new String[severenities.size()]));
        if (this.isAcceptableMessage(facesMsg, acceptLevels)) {
            this.outerStyles(uiMsg, context, writer, facesMsg);
            this.renderMarkerFacet(uiMsg, context, writer, facesMsg);
            this.renderLabel(uiMsg, context, writer, facesMsg);
        }
    }

    @Override
    public void renderOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, String outerStyle, String outerClass) throws IOException {
        UIRichMessage uiMsg = null;
        if (!(component instanceof UIRichMessage)) {
            return;
        }
        uiMsg = (UIRichMessage)component;
        String parentStyle = (String)uiMsg.getAttributes().get("style");
        String parentClass = (String)uiMsg.getAttributes().get("styleClass");
        String richMessageClass = "rich-message" + (null != outerClass ? " " + outerClass : "");
        String richMessageStyle = null != outerStyle ? outerStyle + "," : "";
        parentStyle = parentStyle != null ? richMessageStyle + parentStyle : richMessageStyle;
        parentClass = parentClass != null ? richMessageClass + " " + parentClass : richMessageClass;
        this.getUtils().writeAttribute(writer, "class", parentClass);
        this.getUtils().writeAttribute(writer, "style", parentStyle);
    }

    @Override
    public void renderMarkerHtml(UIComponent component, UIComponent marker, FacesContext context, ResponseWriter writer, String markerClass, String markerStyle) throws IOException {
        UIRichMessage uiMsg = null;
        if (!(component instanceof UIRichMessage)) {
            return;
        }
        uiMsg = (UIRichMessage)component;
        writer.startElement("span", uiMsg);
        String classes = markerClass == null ? "rich-message-marker" : "rich-message-marker " + markerClass;
        this.getUtils().writeAttribute(writer, "class", classes);
        this.getUtils().writeAttribute(writer, "style", markerStyle);
        this.renderChild(context, marker);
        writer.endElement("span");
    }

    @Override
    public void renderLabelHtml(UIComponent component, FacesContext context, ResponseWriter writer, FacesMessage facesMsg, String labelClass, String labelStyle, String passLabel) throws IOException {
        String summary = null;
        String detail = null;
        String title = null;
        UIRichMessage uiMsg = null;
        if (!(component instanceof UIRichMessage)) {
            return;
        }
        uiMsg = (UIRichMessage)component;
        boolean isTooltip = this.getUtils().isBooleanAttribute(uiMsg, "tooltip");
        boolean showSummary = uiMsg.isShowSummary();
        boolean showDetail = uiMsg.isShowDetail();
        if (facesMsg != null) {
            summary = facesMsg.getSummary();
            summary = null != summary ? summary : "";
            detail = facesMsg.getDetail();
            detail = null != detail ? detail : "";
        }
        String classes = labelClass == null ? "rich-message-label" : "rich-message-label " + labelClass;
        writer.startElement("span", uiMsg);
        this.getUtils().writeAttribute(writer, "class", classes);
        this.getUtils().writeAttribute(writer, "style", labelStyle);
        title = (String)component.getAttributes().get("title");
        if (title != null) {
            writer.writeAttribute("title", title, "title");
        }
        if (facesMsg != null) {
            boolean wroteTooltip = false;
            if (showSummary && showDetail && isTooltip) {
                if (title == null || title.length() == 0) {
                    writer.writeAttribute("title", summary, "title");
                }
                wroteTooltip = true;
            }
            if (!wroteTooltip && showSummary) {
                writer.writeText(summary, component, null);
            }
            if (showDetail) {
                writer.writeText(detail, component, null);
            }
        } else if (passLabel != null) {
            writer.writeText(passLabel, null);
            writer.writeText("\t", null);
        }
        writer.endElement("span");
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIMessage.class;
    }
}

