/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DropzoneRendererContributor;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtDropzoneRendererContributor
implements RendererContributor {
    private static ExtDropzoneRendererContributor instance;
    private static RendererContributor wrappedContributor;

    private ExtDropzoneRendererContributor() {
    }

    public static synchronized ExtDropzoneRendererContributor getInstance() {
        if (instance == null) {
            instance = new ExtDropzoneRendererContributor();
            wrappedContributor = DropzoneRendererContributor.getInstance();
        }
        return instance;
    }

    @Override
    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
    }

    @Override
    public Class<?> getAcceptableClass() {
        return wrappedContributor.getAcceptableClass();
    }

    @Override
    public String getScriptContribution(FacesContext context, UIComponent component) {
        return null;
    }

    public String getScriptContribution(FacesContext context, UIComponent column, String dropTargetScriptId, JSFunction preSendAjaxRequestFunction, JSFunctionDefinition onAjaxCompleteFunction) {
        StringBuffer result = new StringBuffer();
        result.append(".drop = ");
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter("event");
        definition.addParameter("drag");
        Map<String, Object> requestOpts = AjaxRendererUtils.buildEventOptions(context, column, true);
        String clientId = column.getClientId(context);
        Map parameters = (Map)requestOpts.get("parameters");
        if (parameters != null && parameters.containsKey(clientId)) {
            parameters.remove(clientId);
            parameters.put(dropTargetScriptId, dropTargetScriptId);
        }
        definition.addToBody("var dragParams = drag.getParameters();");
        String dragSourceScriptId = column.getClientId(context) + ":" + "dnd_drag_script";
        definition.addToBody("var source = dragParams['dragSourceId'];if (source != \"" + dragSourceScriptId + "\"){");
        definition.addToBody("var options = ").addToBody(ScriptUtils.toScript(requestOpts)).addToBody(";");
        definition.addToBody("options.parameters['dropTargetId'] = '" + dropTargetScriptId + "';");
        if (onAjaxCompleteFunction != null) {
            definition.addToBody("options['oncomplete'] = " + onAjaxCompleteFunction.toScript() + ";");
        }
        definition.addToBody("Object.extend(options.parameters, dragParams);");
        if (preSendAjaxRequestFunction != null) {
            definition.addToBody(preSendAjaxRequestFunction.toScript()).addToBody(";");
        }
        definition.addToBody("var dzOptions = this.getDropzoneOptions(); if (dzOptions.ondrop) { if (!dzOptions.ondrop.call(this, event)) return; };");
        JSFunction dropFunction = AjaxRendererUtils.buildAjaxFunction(column, context);
        dropFunction.addParameter(new JSReference("options"));
        definition.addToBody(dropFunction.toScript()).addToBody(";");
        definition.addToBody("};");
        definition.appendScript(result);
        result.append(";");
        return result.toString();
    }

    public String getScriptContribution(FacesContext context, UIComponent column, String dropTargetScriptId) {
        return this.getScriptContribution(context, column, dropTargetScriptId, null, null);
    }

    @Override
    public String[] getScriptDependencies() {
        return wrappedContributor.getScriptDependencies();
    }

    @Override
    public String[] getStyleDependencies() {
        return wrappedContributor.getStyleDependencies();
    }

    @Override
    public ScriptOptions buildOptions(FacesContext context, UIComponent column) {
        ScriptOptions options = new ScriptOptions(column);
        options.addOption("acceptedTypes", "COLUMN_ORDER_" + column.getParent().getClientId(context));
        return options;
    }
}

