/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSLiteral;
import org.richfaces.application.ServiceTracker;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;

public abstract class DivPanelRenderer
extends RendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES = RenderKitUtils.attributes("lang", "onclick", "ondblclick", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "title", "dir");

    protected static String attributeAsStyle(UIComponent comp, Enum attr) {
        return DivPanelRenderer.attributeAsStyle(comp, attr.toString());
    }

    protected static String attributeAsStyle(UIComponent comp, String attr) {
        String value = DivPanelRenderer.attributeAsString(comp, attr);
        if (value.length() == 0) {
            return "";
        }
        return DivPanelRenderer.styleElement(attr, value);
    }

    protected static String styleElement(Object name, Object value) {
        return "" + name + ':' + value;
    }

    protected static String attributeAsString(UIComponent comp, Enum attr) {
        return DivPanelRenderer.attributeAsString(comp, attr.toString());
    }

    protected static String attributeAsString(UIComponent comp, String attr) {
        Object o = comp.getAttributes().get(attr);
        return o == null ? "" : o.toString();
    }

    public static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.doEncodeItemBegin(writer, context, component);
    }

    protected void doEncodeItemBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", component.getClientId(context), "clientId");
        writer.writeAttribute("class", this.getStyleClass(component), null);
        String style = this.getStyle(component);
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", style, null);
        }
        RenderKitUtils.renderPassThroughAttributes(context, component, this.getPassThroughAttributes());
    }

    protected String getStyle(UIComponent component) {
        return DivPanelRenderer.attributeAsString(component, "style");
    }

    protected RenderKitUtils.Attributes getPassThroughAttributes() {
        return PASS_THROUGH_ATTRIBUTES;
    }

    protected String getStyleClass(UIComponent component) {
        return DivPanelRenderer.attributeAsString(component, "styleClass");
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.doEncodeItemEnd(writer, context, component);
    }

    protected void doEncodeItemEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.writeJavaScript(writer, context, component);
        writer.endElement("div");
    }

    protected void writeJavaScript(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        Object script = this.getScriptObject(context, component);
        if (script == null) {
            return;
        }
        JavaScriptService service = ServiceTracker.getService(JavaScriptService.class);
        service.addScript(context, script);
    }

    protected Object getScriptObject(FacesContext context, UIComponent component) {
        return null;
    }

    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        return null;
    }

    protected void addOnCompleteParam(FacesContext context, String panelId) {
        this.addOnCompleteParam(context, "", panelId);
    }

    protected void addOnCompleteParam(FacesContext context, String itemName, String panelId) {
        String script = "RichFaces.component('" + panelId + "').onCompleteHandler('" + itemName + "');";
        JavaScriptService scriptService = ServiceTracker.getService(JavaScriptService.class);
        scriptService.addScript(context, new JSLiteral(script.toString()));
    }
}

