/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.Mode;
import org.richfaces.component.Positioning;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.ContextMenuRendererBase;

public class ContextMenuRenderer
extends ContextMenuRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES43 = RenderKitUtils.attributes().generic("align", "align", new String[0]).generic("dir", "dir", new String[0]).generic("lang", "lang", new String[0]).generic("onclick", "onclick", "click").generic("ondblclick", "ondblclick", "dblclick").generic("onkeydown", "onkeydown", "keydown").generic("onkeypress", "onkeypress", "keypress").generic("onkeyup", "onkeyup", "keyup").generic("onmousedown", "onmousedown", "mousedown").generic("onmousemove", "onmousemove", "mousemove").generic("onmouseout", "onmouseout", "mouseout").generic("onmouseover", "onmouseover", "mouseover").generic("onmouseup", "onmouseup", "mouseup").generic("role", "role", new String[0]).generic("title", "title", new String[0]);
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH37 = RenderKitUtils.attributes().generic("onshow", "onshow", "show").generic("onhide", "onhide", "hide").generic("ongroupshow", "ongroupshow", "groupshow").generic("ongrouphide", "ongrouphide", "grouphide").generic("onitemclick", "onitemclick", "itemclick");

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent component) throws IOException {
        String clientId = component.getClientId(facesContext);
        Object style = component.getAttributes().get("style");
        Object cssRoot = component.getAttributes().get("cssRoot");
        String styleClass = !ContextMenuRenderer.isEmpty(component.getAttributes().get("styleClass")) ? component.getAttributes().get("styleClass") : "";
        boolean isDisabled = this.isDisabled(facesContext, component);
        List<Map<String, Object>> menuGroups = this.getMenuGroups(facesContext, component);
        responseWriter.startElement("div", component);
        String value = "rf-ctx-lbl " + ContextMenuRenderer.convertToString(isDisabled ? "rf-ctx-dis" : "rf-ctx-unsel");
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", value, null);
        }
        if (!this.isDisabled(facesContext, component)) {
            responseWriter.startElement("div", component);
            responseWriter.writeAttribute("class", "rf-ctx-pos", null);
            responseWriter.startElement("div", component);
            value = "rf-ctx-lst " + ContextMenuRenderer.convertToString(styleClass);
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", value, null);
            }
            if (null != (value = ContextMenuRenderer.convertToString(clientId) + "_list") && value.length() > 0) {
                responseWriter.writeAttribute("id", value, null);
            }
            if (null != (value = "display:none;min-width:" + ContextMenuRenderer.convertToString(this.getPopupWidth(component)) + "px; " + ContextMenuRenderer.convertToString(style)) && value.length() > 0) {
                responseWriter.writeAttribute("style", value, null);
            }
            RenderKitUtils.renderPassThroughAttributes(facesContext, component, PASS_THROUGH_ATTRIBUTES43);
            responseWriter.startElement("div", component);
            responseWriter.writeAttribute("class", "rf-ctx-lst-bg", null);
            this.renderChildren(facesContext, component);
            responseWriter.endElement("div");
            responseWriter.endElement("div");
            responseWriter.endElement("div");
            responseWriter.startElement("script", component);
            responseWriter.writeAttribute("type", "text/javascript", null);
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
            RenderKitUtils.addToScriptHash(options, "direction", this.getDirection(component).getValue(), Positioning.DEFAULT.getValue(), null);
            RenderKitUtils.addToScriptHash(options, "jointPoint", this.getJointPoint(component).getValue(), Positioning.DEFAULT.getValue(), null);
            RenderKitUtils.addToScriptHash(options, "showEvent", this.getShowEvent(component), "contextmenu", null);
            RenderKitUtils.addToScriptHash(options, "target", this.getTarget(facesContext, component), "", null);
            RenderKitUtils.addToScriptHash(options, "attached", component.getAttributes().get("attached"), true, null);
            RenderKitUtils.addToScriptHash(options, "mode", (Object)this.getMode(component), (Object)Mode.server, null);
            RenderKitUtils.addToScriptHash(options, "horizontalOffset", component.getAttributes().get("horizontalOffset"), 0, null);
            RenderKitUtils.addToScriptHash(options, "verticalOffset", component.getAttributes().get("verticalOffset"), 0, null);
            RenderKitUtils.addToScriptHash(options, "hideDelay", component.getAttributes().get("hideDelay"), 300, null);
            RenderKitUtils.addToScriptHash(options, "showDelay", component.getAttributes().get("showDelay"), 50, null);
            RenderKitUtils.addToScriptHash(options, "targetSelector", component.getAttributes().get("targetSelector"), "", null);
            RenderKitUtils.addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH37, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
            String text = "new RichFaces.ui.ContextMenu(" + ContextMenuRenderer.convertToString(RenderKitUtils.toScriptArgs(clientId, options)) + ")";
            if (text != null) {
                responseWriter.writeText(text, null);
            }
            if (!ContextMenuRenderer.isEmpty(menuGroups) && (text = ".initiateGroups(" + ContextMenuRenderer.convertToString(RenderKitUtils.toScriptArgs(menuGroups)) + ")") != null) {
                responseWriter.writeText(text, null);
            }
            responseWriter.writeText(";", null);
            responseWriter.endElement("script");
        }
        responseWriter.endElement("div");
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }
}

