/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractAccordionItem;
import org.richfaces.component.AbstractTogglePanelTitledItem;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.html.TableIconsRendererHelper;
import org.richfaces.renderkit.util.PanelIcons;

class AccordionItemHeaderRenderer
extends TableIconsRendererHelper<AbstractAccordionItem> {
    public AccordionItemHeaderRenderer() {
        super("header", "rf-ac-itm");
    }

    @Override
    protected void encodeHeaderLeftIcon(ResponseWriter writer, FacesContext context, AbstractAccordionItem panel) throws IOException {
        String iconInactive = panel.isDisabled() ? panel.getLeftDisabledIcon() : panel.getLeftInactiveIcon();
        String iconActive = panel.isDisabled() ? panel.getLeftDisabledIcon() : panel.getLeftActiveIcon();
        this.encodeTdIcon(writer, context, this.cssClassPrefix + "-ico", iconInactive, iconActive, panel.isDisabled() ? PanelIcons.State.headerDisabled : PanelIcons.State.header);
    }

    @Override
    protected void encodeHeaderRightIcon(ResponseWriter writer, FacesContext context, AbstractAccordionItem panel) throws IOException {
        String iconInactive = panel.isDisabled() ? panel.getRightDisabledIcon() : panel.getRightInactiveIcon();
        String iconActive = panel.isDisabled() ? panel.getRightDisabledIcon() : panel.getRightActiveIcon();
        this.encodeTdIcon(writer, context, this.cssClassPrefix + "-exp-ico", iconInactive, iconActive, panel.isDisabled() ? PanelIcons.State.headerDisabled : PanelIcons.State.header);
    }

    @Override
    protected void encodeTdIcon(ResponseWriter writer, FacesContext context, String cssClass, String attrIconCollapsedValue, String attrIconExpandedValue, PanelIcons.State state) throws IOException {
        if (this.isIconRendered(attrIconCollapsedValue) || this.isIconRendered(attrIconExpandedValue)) {
            writer.startElement("td", null);
            writer.writeAttribute("class", cssClass, null);
            if (this.isIconRendered(attrIconExpandedValue)) {
                this.encodeIdIcon(writer, context, attrIconExpandedValue, this.cssIconsClassPrefix + "-act", state);
            }
            if (this.isIconRendered(attrIconCollapsedValue)) {
                this.encodeIdIcon(writer, context, attrIconCollapsedValue, this.cssIconsClassPrefix + "-inact", state);
            }
            writer.endElement("td");
        }
    }

    @Override
    protected void encodeHeaderTextValue(ResponseWriter writer, FacesContext context, AbstractAccordionItem titledItem) throws IOException {
        if (titledItem.isDisabled()) {
            AccordionItemHeaderRenderer.encodeHeader(writer, context, titledItem, AbstractTogglePanelTitledItem.HeaderStates.disabled);
        } else {
            AccordionItemHeaderRenderer.encodeHeader(writer, context, titledItem, AbstractTogglePanelTitledItem.HeaderStates.active);
            AccordionItemHeaderRenderer.encodeHeader(writer, context, titledItem, AbstractTogglePanelTitledItem.HeaderStates.inactive);
        }
    }

    private static void encodeHeader(ResponseWriter writer, FacesContext context, AbstractAccordionItem component, AbstractTogglePanelTitledItem.HeaderStates state) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("class", HtmlUtil.concatClasses("rf-ac-itm-lbl-" + state.abbreviation(), DivPanelRenderer.attributeAsString((UIComponent)component, state.headerClass())), null);
        AccordionItemHeaderRenderer.writeFacetOrAttr(writer, context, (UIComponent)component, "header", component.getHeaderFacet(state));
        writer.endElement("div");
    }
}

