/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.application.ServiceTracker;
import org.richfaces.component.AbstractMessage;
import org.richfaces.component.AbstractMessages;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.MessageForRender;
import org.richfaces.renderkit.MessageTransformer;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.RendererUtils;

public class MessageRendererBase
extends RendererBase {
    private static final ImmutableMap<FacesMessage.Severity, SeverityAttributes> SEVERITY_MAP = ImmutableMap.of(FacesMessage.SEVERITY_INFO, MessageRendererBase.attrs("info", "inf"), FacesMessage.SEVERITY_WARN, MessageRendererBase.attrs("warn", "wrn"), FacesMessage.SEVERITY_ERROR, MessageRendererBase.attrs("error", "err"), FacesMessage.SEVERITY_FATAL, MessageRendererBase.attrs("fatal", "ftl"));

    protected Iterator<MessageForRender> getMessages(FacesContext context, String forClientId, UIComponent component) {
        Iterator<MessageForRender> msgIter;
        if (forClientId != null) {
            if (forClientId.length() != 0) {
                UIComponent result = RendererUtils.getInstance().findComponentFor(component, forClientId);
                if (result == null) {
                    msgIter = ImmutableSet.of().iterator();
                } else {
                    String clientId = result.getClientId(context);
                    msgIter = this.getMessagesForId(context, clientId);
                }
            } else {
                msgIter = this.getMessagesForId(context, null);
            }
        } else {
            msgIter = ImmutableSet.of().iterator();
            Iterator<String> clientIdsWithMessages = context.getClientIdsWithMessages();
            while (clientIdsWithMessages.hasNext()) {
                String clientId = clientIdsWithMessages.next();
                msgIter = Iterators.concat(msgIter, this.getMessagesForId(context, clientId));
            }
        }
        return msgIter;
    }

    private Iterator<MessageForRender> getMessagesForId(FacesContext context, String clientId) {
        Iterator<MessageForRender> msgIter = Iterators.transform(context.getMessages(clientId), new MessageTransformer(null == clientId ? "" : clientId));
        return msgIter;
    }

    protected Iterable<MessageForRender> getVisibleMessages(FacesContext context, UIComponent component) {
        String forId = this.getFor(component);
        Iterator<MessageForRender> messages = this.getMessages(context, forId, component);
        UnmodifiableIterator<MessageForRender> filteredMessages = Iterators.filter(messages, this.getMessagesLevelFilter(context, component));
        return Lists.newArrayList(filteredMessages);
    }

    private Predicate<MessageForRender> getMessagesLevelFilter(FacesContext context, UIComponent component) {
        final FacesMessage.Severity level = this.getLevel(component);
        final boolean displayAll = this.isComponentMessages(component);
        final boolean redisplay = Boolean.TRUE.equals(component.getAttributes().get("redisplay"));
        Predicate<MessageForRender> predicate = new Predicate<MessageForRender>(){
            private int count = 0;

            @Override
            public boolean apply(MessageForRender input) {
                if ((redisplay || !input.isRendered()) && input.getSeverity().compareTo(level) >= 0) {
                    return displayAll || 0 == this.count++;
                }
                return false;
            }
        };
        return predicate;
    }

    protected FacesMessage.Severity getLevel(UIComponent component) {
        Object levelName = component.getAttributes().get("level");
        FacesMessage.Severity level = FacesMessage.VALUES_MAP.containsKey(levelName) ? FacesMessage.VALUES_MAP.get(levelName) : FacesMessage.SEVERITY_INFO;
        return level;
    }

    protected boolean isComponentMessage(UIComponent component) {
        return component instanceof UIMessage;
    }

    protected boolean isComponentRichMessage(UIComponent component) {
        return component instanceof AbstractMessage;
    }

    protected boolean isComponentMessages(UIComponent component) {
        return component instanceof UIMessages;
    }

    protected boolean isComponentRichMessages(UIComponent component) {
        return component instanceof AbstractMessages;
    }

    private String getFor(UIComponent component) {
        if (this.isComponentMessages(component)) {
            UIMessages messages = (UIMessages)component;
            if (messages.isGlobalOnly()) {
                return "";
            }
            return messages.getFor();
        }
        if (this.isComponentMessage(component)) {
            UIMessage message = (UIMessage)component;
            return message.getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    protected void encodeMessage(FacesContext facesContext, UIComponent component, Object msg) throws IOException {
        MessageForRender message = (MessageForRender)msg;
        String summary = message.getSummary();
        String detail = message.getDetail();
        boolean showSummary = true;
        boolean showDetail = false;
        boolean isMessages = false;
        if (this.isComponentMessage(component)) {
            UIMessage uiMessage = (UIMessage)component;
            showSummary = uiMessage.isShowSummary();
            showDetail = uiMessage.isShowDetail();
        } else if (this.isComponentMessages(component)) {
            UIMessages uiMessages = (UIMessages)component;
            showSummary = uiMessages.isShowSummary();
            showDetail = uiMessages.isShowDetail();
            isMessages = true;
        }
        boolean escape = true;
        if (this.isComponentRichMessage(component)) {
            AbstractMessage richMessage = (AbstractMessage)component;
            escape = richMessage.isEscape();
        }
        if (this.isComponentRichMessages(component)) {
            AbstractMessages richMessages = (AbstractMessages)component;
            escape = richMessages.isEscape();
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.writeAttribute("id", component.getClientId() + ':' + message.getSourceId(), null);
        boolean wroteTooltip = RendererUtils.getInstance().isBooleanAttribute(component, "tooltip");
        if (wroteTooltip && !Strings.isNullOrEmpty(summary)) {
            responseWriter.writeAttribute("title", summary, null);
        }
        if (!wroteTooltip && showSummary) {
            this.writeMessageLabel(responseWriter, summary, isMessages ? "rf-msgs-sum" : "rf-msg-sum", escape);
        }
        if (showDetail) {
            this.writeMessageLabel(responseWriter, detail, isMessages ? "rf-msgs-det" : "rf-msg-det", escape);
        }
        message.rendered();
    }

    private void writeMessageLabel(ResponseWriter responseWriter, String label, String styleClass, boolean escape) throws IOException {
        if (!Strings.isNullOrEmpty(label)) {
            responseWriter.startElement("span", null);
            responseWriter.writeAttribute("class", styleClass, null);
            if (escape) {
                responseWriter.writeText(label, null);
            } else {
                responseWriter.write(label);
            }
            responseWriter.endElement("span");
        }
    }

    protected String getJSClassName() {
        return "RichFaces.ui.Message";
    }

    protected void encodeScript(FacesContext facesContext, UIComponent component) throws IOException {
        FacesMessage.Severity level;
        UIComponent target;
        JavaScriptService javaScriptService = ServiceTracker.getService(JavaScriptService.class);
        JSObject messageObject = new JSObject(this.getJSClassName(), component.getClientId(facesContext));
        Map<String, Object> attributes = component.getAttributes();
        ImmutableMap.Builder<String, Object> parametersBuilder = ImmutableMap.builder();
        String forId = (String)attributes.get("for");
        RendererUtils rendererUtils = RendererUtils.getInstance();
        if (!Strings.isNullOrEmpty(forId) && null != (target = rendererUtils.findComponentFor(component, forId))) {
            parametersBuilder.put("forComponentId", target.getClientId(facesContext));
        }
        if (FacesMessage.SEVERITY_INFO != (level = this.getLevel(component))) {
            parametersBuilder.put("level", level.getOrdinal());
        }
        if (!rendererUtils.isBooleanAttribute(component, "showSummary")) {
            parametersBuilder.put("showSummary", false);
        }
        if (rendererUtils.isBooleanAttribute(component, "showDetail")) {
            parametersBuilder.put("showDetail", true);
        }
        if (rendererUtils.isBooleanAttribute(component, "tooltip")) {
            parametersBuilder.put("tooltip", true);
        }
        if (this.isComponentMessages(component) && rendererUtils.isBooleanAttribute(component, "globalOnly")) {
            parametersBuilder.put("globalOnly", true);
        }
        if (this.isComponentMessages(component)) {
            parametersBuilder.put("isMessages", true);
        }
        messageObject.addParameter(parametersBuilder.build());
        javaScriptService.addPageReadyScript(facesContext, messageObject);
    }

    protected String getMsgClass(FacesContext facesContext, UIComponent component, Object msg) throws IOException {
        MessageForRender message = (MessageForRender)msg;
        SeverityAttributes severityAttributes = SEVERITY_MAP.get(message.getSeverity());
        boolean isMessages = this.isComponentMessages(component);
        String styleClass = this.buildSeverityAttribute(component, isMessages ? severityAttributes.messagesSkinClass : severityAttributes.messageSkinClass, severityAttributes.classAttribute, ' ');
        return styleClass;
    }

    protected String getMsgStyle(FacesContext facesContext, UIComponent component, Object msg) throws IOException {
        MessageForRender message = (MessageForRender)msg;
        SeverityAttributes severityAttributes = SEVERITY_MAP.get(message.getSeverity());
        String style = this.buildSeverityAttribute(component, null, severityAttributes.styleAttribute, ';');
        return style;
    }

    private String buildSeverityAttribute(UIComponent component, String skinValue, String attrName, char delimiter) {
        Object componentStyle;
        StringBuilder style = new StringBuilder();
        if (!Strings.isNullOrEmpty(skinValue)) {
            style.append(skinValue);
        }
        if (null != (componentStyle = component.getAttributes().get(attrName)) && !Strings.isNullOrEmpty(componentStyle.toString())) {
            if (!Strings.isNullOrEmpty(skinValue)) {
                style.append(delimiter);
            }
            style.append(componentStyle);
        }
        return style.toString();
    }

    static SeverityAttributes attrs(String attPrefix, String skinSuffix) {
        SeverityAttributes attrs = new SeverityAttributes(attPrefix, skinSuffix);
        return attrs;
    }

    private static final class SeverityAttributes {
        private final String styleAttribute;
        private final String classAttribute;
        private final String messageSkinClass;
        private final String messagesSkinClass;

        private SeverityAttributes(String attPrefix, String skinSuffix) {
            this.styleAttribute = attPrefix + "Style";
            this.classAttribute = attPrefix + "Class";
            this.messageSkinClass = "rf-msg-" + skinSuffix;
            this.messagesSkinClass = "rf-msgs-" + skinSuffix;
        }
    }
}

