/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractDragSource;
import org.richfaces.component.AbstractDropTarget;
import org.richfaces.event.DropEvent;
import org.richfaces.javascript.DnDScript;
import org.richfaces.javascript.DropScript;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.DnDRenderBase;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.util.Sets;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="com.jqueryui", name="core.js"), @ResourceDependency(library="com.jqueryui", name="widget.js"), @ResourceDependency(library="com.jqueryui", name="mouse.js"), @ResourceDependency(library="com.jqueryui", name="draggable.js"), @ResourceDependency(library="com.jqueryui", name="droppable.js"), @ResourceDependency(library="org.richfaces", name="dnd-droppable.js")})
public class DropTargetRenderer
extends DnDRenderBase {
    private static final Set<String> ALL_SET = Collections.singleton("@all");
    private static final Set<String> NONE_SET = Collections.singleton("@none");

    @Override
    protected void doDecode(FacesContext facesContext, UIComponent component) {
        Map<String, String> requestParamMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParamMap.get(component.getClientId(facesContext)) == null) {
            return;
        }
        String dragSourceId = requestParamMap.get("dragSource");
        if (Strings.isNullOrEmpty(dragSourceId)) {
            return;
        }
        DragSourceContextCallBack dragSourceContextCallBack = new DragSourceContextCallBack();
        boolean invocationResult = facesContext.getViewRoot().invokeOnComponent(facesContext, dragSourceId, dragSourceContextCallBack);
        if (!invocationResult) {
            return;
        }
        AbstractDropTarget dropTarget = (AbstractDropTarget)component;
        new DropEvent((UIComponent)dropTarget, dropTarget.getDropValue(), (UIComponent)dragSourceContextCallBack.getDragSource(), dragSourceContextCallBack.getDragValue()).queue();
    }

    @Override
    public DnDScript createScript(String name) {
        return new DropScript(name);
    }

    @Override
    public Map<String, Object> getOptions(FacesContext facesContext, UIComponent component) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (component instanceof AbstractDropTarget) {
            JSReference dragSourceId = new JSReference("dragSourceId");
            JSFunctionDefinition function = new JSFunctionDefinition(JSReference.EVENT, dragSourceId);
            AjaxFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(facesContext, component);
            ajaxFunction.getOptions().setParameter("dragSource", dragSourceId);
            ajaxFunction.getOptions().setParameter(component.getClientId(facesContext), component.getClientId(facesContext));
            ajaxFunction.setSource(new JSReference("event", "target"));
            ajaxFunction.getOptions().setAjaxComponent(component.getClientId(facesContext));
            function.addToBody(ajaxFunction);
            AbstractDropTarget dropTarget = (AbstractDropTarget)component;
            Set<String> acceptedTypes = Sets.asSet(dropTarget.getAcceptedTypes());
            if (acceptedTypes != null) {
                if (acceptedTypes.contains("@none")) {
                    acceptedTypes = NONE_SET;
                } else if (acceptedTypes.contains("@all")) {
                    acceptedTypes = ALL_SET;
                }
            }
            options.put("acceptedTypes", acceptedTypes);
            options.put("ajaxFunction", function);
            options.put("parentId", this.getParentClientId(facesContext, component));
        }
        return options;
    }

    @Override
    public String getScriptName() {
        return "new RichFaces.ui.Droppable";
    }

    private final class DragSourceContextCallBack
    implements ContextCallback {
        private AbstractDragSource dragSource;
        private Object dragValue;

        private DragSourceContextCallBack() {
        }

        @Override
        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (target instanceof AbstractDragSource) {
                this.dragSource = (AbstractDragSource)target;
                this.dragValue = this.dragSource.getDragValue();
            }
        }

        public AbstractDragSource getDragSource() {
            return this.dragSource;
        }

        public Object getDragValue() {
            return this.dragValue;
        }
    }
}

