/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.javascript.ScriptStringBase;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIComponentControl;
import org.richfaces.component.util.HtmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentControlRendererBase
extends HeaderResourcesRendererBase {
    private static final String IMMEDIATE = "immediate";
    private static final String ON_AVAILABLE = "onavailable";
    private static final String ON_LOAD = "onload";
    private final InternetResource[] additionalScripts = new InternetResource[]{new PrototypeScript(), new AjaxScript(), this.getResource("/org/richfaces/renderkit/html/scripts/available.js")};

    protected Class<UIComponentControl> getComponentClass() {
        return UIComponentControl.class;
    }

    protected void checkValidity(String clientId, String name, String attachTiming, String forAttr, String operation) {
        if (!(ON_LOAD.equals(attachTiming) || IMMEDIATE.equals(attachTiming) || ON_AVAILABLE.equals(attachTiming))) {
            throw new FacesException("The attachTiming attribute of the controlComponent  (id='" + clientId + "') has an invalid value:'" + attachTiming + "'. It may have only the following values: '" + IMMEDIATE + "', '" + ON_LOAD + "', '" + ON_AVAILABLE + "'");
        }
        if (operation == null || operation.trim().length() == 0) {
            throw new FacesException("The operation attribute of the controlComponent (id='" + clientId + "') must be specified");
        }
    }

    protected String replaceClientIds(FacesContext context, UIComponent component, String selector) {
        return HtmlUtil.expandIdSelector(HtmlUtil.idsToIdSelector(selector), component, context);
    }

    @Override
    protected InternetResource[] getScripts() {
        return this.additionalScripts;
    }

    private static String convertToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public void writeScript(FacesContext context, UIComponent component) throws IOException {
        UIComponentControl componentControl = (UIComponentControl)component;
        ResponseWriter writer = context.getResponseWriter();
        Map<String, Object> attributes = component.getAttributes();
        String name = ComponentControlRendererBase.convertToString(attributes.get("name"));
        String attachTo = ComponentControlRendererBase.convertToString(attributes.get("attachTo"));
        String forAttr = ComponentControlRendererBase.convertToString(attributes.get("for"));
        forAttr = this.replaceClientIds(context, component, forAttr);
        String operation = ComponentControlRendererBase.convertToString(attributes.get("operation"));
        String attachTiming = componentControl.getAttachTiming();
        this.checkValidity(componentControl.getClientId(context), name, attachTiming, forAttr, operation);
        String event = ComponentControlRendererBase.convertToString(attributes.get("event"));
        ScriptStringBase namedFunction = null;
        ScriptStringBase eventFunction = null;
        if (name.trim().length() != 0) {
            JSFunction subFunction = new JSFunction("Richfaces.componentControl.performOperation", new Object[0]);
            subFunction.addParameter(new JSReference("event"));
            componentControl.addOptions(subFunction, event, forAttr, operation);
            namedFunction = new JSFunctionDefinition("event");
            ((JSFunctionDefinition)namedFunction).setName(name);
            ((JSFunctionDefinition)namedFunction).addToBody(subFunction);
        }
        if (attachTo != null && attachTo.trim().length() != 0 && !"#".equals(attachTo)) {
            boolean isImmediate = attachTiming.equals(IMMEDIATE);
            boolean isOnLoad = attachTiming.equals(ON_LOAD);
            boolean isOnAvailable = attachTiming.equals(ON_AVAILABLE);
            if (isOnLoad) {
                eventFunction = new JSFunction("Richfaces.componentControl.attachReady", new Object[0]);
            } else if (isOnAvailable) {
                eventFunction = new JSFunction("Richfaces.componentControl.attachAvailable", new Object[0]);
            } else if (isImmediate) {
                eventFunction = new JSFunction("Richfaces.componentControl.attachEvent", new Object[0]);
            } else {
                return;
            }
            String selector = this.replaceClientIds(context, component, attachTo);
            ((JSFunction)eventFunction).addParameter(selector);
            componentControl.addOptions((JSFunction)eventFunction, event, forAttr, operation);
        }
        if (eventFunction != null || namedFunction != null) {
            writer.startElement("script", componentControl);
            this.getUtils().writeAttribute(writer, "type", "text/javascript");
            if (namedFunction != null) {
                writer.writeText(namedFunction.toScript(), component, null);
                writer.writeText(";", component, null);
            }
            if (eventFunction != null) {
                writer.writeText(eventFunction.toScript(), component, null);
            }
            writer.endElement("script");
        }
    }
}

