/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.component.AbstractCollapsibleSubTable;
import org.richfaces.component.AbstractCollapsibleSubTableToggler;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.RendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="collapsible-subtable-toggler.js"), @ResourceDependency(library="org.richfaces", name="collapsible-subtable.ecss")})
public abstract class CollapsibleSubTableTogglerRendererBase
extends RendererBase {
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();
    private static final String DISPLAY_NONE = "display: none;";
    private static final String UP_ICON_URL = "org.richfaces/up_icon.gif";
    private static final String DOWN_ICON_URL = "org.richfaces/down_icon.gif";
    private static final String EXPANDED_STATE = "expanded";
    private static final String COLLAPSED_STATE = "collapsed";
    private static final String EXPANDED_CONTROL_CLASS = "rf-csttg-exp";
    private static final String COLLAPSED_CONTROL_CLASS = "rf-csttg-colps";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        context.getPartialViewContext().getRenderIds().add(component.getClientId(context));
    }

    protected void encodeControl(FacesContext context, UIComponent component) throws IOException {
        AbstractCollapsibleSubTableToggler toggleControl = (AbstractCollapsibleSubTableToggler)component;
        AbstractCollapsibleSubTable subTable = this.findComponent(context, toggleControl);
        if (subTable != null) {
            boolean expanded = subTable.isExpanded();
            ResponseWriter writer = context.getResponseWriter();
            this.encodeControl(context, writer, toggleControl, expanded, true);
            this.encodeControl(context, writer, toggleControl, !expanded, false);
            JSFunction jsFunction = new JSFunction("new RichFaces.ui.CollapsibleSubTableToggler", new Object[0]);
            String toggleId = toggleControl.getClientId(context);
            jsFunction.addParameter(toggleId);
            HashMap<String, Object> options = this.encodeOptions(context, toggleControl, subTable);
            jsFunction.addParameter(options);
            writer.startElement("script", subTable);
            writer.writeText(jsFunction.toScript(), null);
            writer.endElement("script");
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    protected void encodeControl(FacesContext context, ResponseWriter writer, AbstractCollapsibleSubTableToggler control, boolean expanded, boolean visible) throws IOException {
        String label;
        String image;
        String expandedIcon;
        String state = this.getState(expanded);
        String styleClass = this.getStyleClass(context, control);
        String style = this.getStyle(context, control);
        writer.startElement("span", control);
        if (!visible) {
            writer.writeAttribute("style", DISPLAY_NONE, null);
        }
        writer.writeAttribute("id", control.getClientId(context) + ":" + state, null);
        writer.writeAttribute("class", this.concatClasses(styleClass, expanded ? EXPANDED_CONTROL_CLASS : COLLAPSED_CONTROL_CLASS), null);
        writer.writeAttribute("style", style, null);
        UIComponent controlFacet = control.getFacet(state);
        if (controlFacet != null && controlFacet.isRendered()) {
            if (!visible) {
                String facetStyle = (String)controlFacet.getAttributes().get("style");
                facetStyle = facetStyle != null ? facetStyle + ";" + DISPLAY_NONE : DISPLAY_NONE;
                controlFacet.getAttributes().put("style", facetStyle);
            }
            controlFacet.encodeAll(context);
        }
        expandedIcon = this.isEmpty(expandedIcon = control.getExpandedIcon()) ? context.getApplication().getResourceHandler().createResource(DOWN_ICON_URL).getRequestPath() : RenderKitUtils.getResourceURL(expandedIcon, context);
        String collapsedIcon = control.getCollapsedIcon();
        collapsedIcon = this.isEmpty(collapsedIcon) ? context.getApplication().getResourceHandler().createResource(UP_ICON_URL).getRequestPath() : RenderKitUtils.getResourceURL(collapsedIcon, context);
        String string = image = expanded ? expandedIcon : collapsedIcon;
        if (image != null && image.trim().length() > 0) {
            writer.startElement("img", control);
            writer.writeAttribute("src", image, null);
            writer.writeAttribute("alt", "", null);
            writer.endElement("img");
        }
        String string2 = label = expanded ? control.getExpandedLabel() : control.getCollapsedLabel();
        if (label != null && label.trim().length() > 0) {
            writer.startElement("a", control);
            writer.writeAttribute("href", "javascript:void(0);", null);
            writer.writeAttribute("class", "rf-csttg-lnk", null);
            writer.writeText(label, null);
            writer.endElement("a");
        }
        writer.endElement("span");
    }

    public HashMap<String, Object> encodeOptions(FacesContext context, AbstractCollapsibleSubTableToggler toggleControl, AbstractCollapsibleSubTable subTable) {
        String forId = subTable.getClientId(context);
        String toggleControlId = toggleControl.getClientId(context);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("forId", forId);
        options.put("expandedControl", toggleControlId + ":expanded");
        options.put("collapsedControl", toggleControlId + ":collapsed");
        String eventName = toggleControl.getEvent();
        if (Strings.isNullOrEmpty(eventName)) {
            eventName = "onclick";
        }
        eventName = eventName.trim().startsWith("on") ? eventName.substring(2) : eventName;
        options.put("eventName", eventName);
        return options;
    }

    public String getStyleClass(FacesContext context, AbstractCollapsibleSubTableToggler control) {
        return null;
    }

    public String getStyle(FacesContext context, AbstractCollapsibleSubTableToggler control) {
        return null;
    }

    protected AbstractCollapsibleSubTable findComponent(FacesContext context, AbstractCollapsibleSubTableToggler toggleControl) {
        UIComponent subTable;
        String forId = toggleControl.getFor();
        if (forId != null && forId.length() > 0 && (subTable = RENDERER_UTILS.findComponentFor(toggleControl, forId)) instanceof AbstractCollapsibleSubTable) {
            return (AbstractCollapsibleSubTable)subTable;
        }
        return null;
    }

    protected String getState(boolean expanded) {
        return expanded ? EXPANDED_STATE : COLLAPSED_STATE;
    }
}

