/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.iterators;

import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.richfaces.component.ComponentPredicates;
import org.richfaces.component.TreeModelAdaptor;
import org.richfaces.component.TreeModelRecursiveAdaptor;
import org.richfaces.model.SequenceRowKey;
import org.richfaces.model.TreeDataModelTuple;
import org.richfaces.model.iterators.IterableDataTuplesIterator;
import org.richfaces.model.iterators.MapDataTuplesIterator;

public class DeclarativeTreeDataModelCompositeTuplesIterator
extends ForwardingIterator<TreeDataModelTuple> {
    private UIComponent component;
    private SequenceRowKey key;
    private Iterator<TreeDataModelTuple> iterator;

    public DeclarativeTreeDataModelCompositeTuplesIterator(UIComponent component, SequenceRowKey key) {
        this.component = component;
        this.key = key;
    }

    @Override
    protected Iterator<TreeDataModelTuple> delegate() {
        if (this.iterator == null) {
            TreeModelRecursiveAdaptor parentRecursiveAdaptor;
            Object nodes;
            Iterator<TreeDataModelTuple> tuplesIterator;
            ArrayList<Iterator<TreeDataModelTuple>> list = Lists.newArrayList();
            if (this.component instanceof TreeModelRecursiveAdaptor && (tuplesIterator = this.createTuplesIterator(this.component, nodes = (parentRecursiveAdaptor = (TreeModelRecursiveAdaptor)((Object)this.component)).getNodes())) != null) {
                list.add(tuplesIterator);
            }
            if (this.component.getChildCount() > 0) {
                for (UIComponent child : Iterables.filter(this.component.getChildren(), ComponentPredicates.isRendered())) {
                    Iterator<TreeDataModelTuple> tuplesIterator2;
                    Object nodes2 = null;
                    if (child instanceof TreeModelRecursiveAdaptor) {
                        TreeModelRecursiveAdaptor treeModelRecursiveAdaptor = (TreeModelRecursiveAdaptor)((Object)child);
                        nodes2 = treeModelRecursiveAdaptor.getRoots();
                    } else if (child instanceof TreeModelAdaptor) {
                        TreeModelAdaptor treeModelAdaptor = (TreeModelAdaptor)((Object)child);
                        nodes2 = treeModelAdaptor.getNodes();
                    }
                    if ((tuplesIterator2 = this.createTuplesIterator(child, nodes2)) == null) continue;
                    list.add(tuplesIterator2);
                }
            }
            this.iterator = Iterators.concat(list.iterator());
        }
        return this.iterator;
    }

    private Iterator<TreeDataModelTuple> createTuplesIterator(UIComponent component, Object nodes) {
        if (nodes != null) {
            if (nodes instanceof Iterable) {
                Iterable iterable = (Iterable)nodes;
                return new IterableDataTuplesIterator(this.key, iterable.iterator(), component);
            }
            if (nodes instanceof Map) {
                Map map = (Map)nodes;
                return new MapDataTuplesIterator(this.key, map, component);
            }
        }
        return null;
    }
}

