/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.iterators;

import com.google.common.collect.UnmodifiableIterator;
import javax.faces.component.UIComponent;
import org.richfaces.model.DeclarativeModelKey;
import org.richfaces.model.DeclarativeTreeDataModelTuple;
import org.richfaces.model.SequenceRowKey;
import org.richfaces.model.TreeDataModelTuple;

public abstract class BaseTupleIterator
extends UnmodifiableIterator<TreeDataModelTuple> {
    private SequenceRowKey baseKey;
    private UIComponent component;
    private Object rowKey;
    private Object data;

    public BaseTupleIterator(SequenceRowKey baseKey) {
        this(baseKey, null);
    }

    public BaseTupleIterator(SequenceRowKey baseKey, UIComponent component) {
        this.baseKey = baseKey;
        this.component = component;
    }

    protected abstract void proceedToNext();

    protected UIComponent getComponent() {
        return this.component;
    }

    protected SequenceRowKey getBaseKey() {
        return this.baseKey;
    }

    protected void setKeyAndData(Object rowKey, Object data) {
        this.rowKey = rowKey;
        this.data = data;
    }

    protected Object getKey() {
        return this.rowKey;
    }

    @Override
    public final TreeDataModelTuple next() {
        this.proceedToNext();
        Object modelKey = this.getWrappedKey();
        SequenceRowKey nextKey = this.getCompositeKey(modelKey);
        return this.createTuple(nextKey);
    }

    protected TreeDataModelTuple createTuple(SequenceRowKey key) {
        TreeDataModelTuple result = this.component != null ? new DeclarativeTreeDataModelTuple(key, this.data, this.component) : new TreeDataModelTuple(key, this.data);
        return result;
    }

    protected Object getWrappedKey() {
        Object modelKey = this.getComponent() != null ? new DeclarativeModelKey(this.getComponent().getId(), this.getKey()) : this.getKey();
        return modelKey;
    }

    protected SequenceRowKey getCompositeKey(Object modelKey) {
        SequenceRowKey result = this.getBaseKey() != null ? this.getBaseKey().append(modelKey) : new SequenceRowKey(modelKey);
        return result;
    }
}

