/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.converter;

import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.ajax4jsf.Messages;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.converter.BaseTreeConverter;
import org.richfaces.model.ListRowKey;
import org.richfaces.model.StackingTreeModelKey;
import org.richfaces.model.TreeRowKey;

public class TreeAdaptorRowKeyConverter
extends BaseTreeConverter {
    public static final String CONVERTER_ID = "org.richfaces.TreeAdaptorRowKeyConverter";

    protected Object convertStringToModelKey(FacesContext context, UIComponent component, String modelId, String value) {
        return value;
    }

    protected String convertModelKeyToString(FacesContext context, UIComponent component, String modelId, Object value) {
        return value.toString();
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            ArrayList<StackingTreeModelKey<Object>> keys = new ArrayList<StackingTreeModelKey<Object>>();
            Iterator<String> iterator = this.splitKeyString(value).iterator();
            while (iterator.hasNext()) {
                String modelId = iterator.next();
                String modelKey = iterator.next();
                Object convertedModelKey = this.convertStringToModelKey(context, component, modelId, modelKey);
                keys.add(new StackingTreeModelKey<Object>(modelId, convertedModelKey));
            }
            return new ListRowKey(keys);
        }
        catch (Exception e) {
            Object label = MessageUtil.getLabel((FacesContext)context, (UIComponent)component);
            String summary = Messages.getMessage("COMPONENT_CONVERSION_ERROR", label, value);
            throw new ConverterException(new FacesMessage(summary), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (value == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            TreeRowKey treeRowKey = (TreeRowKey)value;
            Iterator iterator = treeRowKey.iterator();
            while (iterator.hasNext()) {
                StackingTreeModelKey key = (StackingTreeModelKey)iterator.next();
                String modelId = key.getModelId();
                this.appendToKeyString(sb, modelId);
                Object modelKey = key.getModelKey();
                String convertedModelKey = this.convertModelKeyToString(context, component, modelId, modelKey);
                this.appendToKeyString(sb, convertedModelKey);
            }
            return sb.toString();
        }
        catch (Exception e) {
            Object label = MessageUtil.getLabel((FacesContext)context, (UIComponent)component);
            String summary = Messages.getMessage("COMPONENT_CONVERSION_ERROR", label, value);
            throw new ConverterException(new FacesMessage(summary), (Throwable)e);
        }
    }
}

