/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert;

import java.text.MessageFormat;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;

public final class TreeConverterUtil {
    private static final char ESCAPE_CHAR = '_';

    private TreeConverterUtil() {
    }

    private static boolean shouldEscape(char c) {
        if ('a' <= c && c <= 'z') {
            return false;
        }
        if ('A' <= c && c <= 'Z') {
            return false;
        }
        if ('0' <= c && c <= '9') {
            return false;
        }
        if (c == '_' || c == SeparatorCharHolder.SEPARATOR_CHAR) {
            return true;
        }
        if ('-' == c || '\u00b7' == c) {
            return false;
        }
        if ('\u00c0' <= c && c <= '\u00d6') {
            return false;
        }
        if ('\u00d8' <= c && c <= '\u00f6') {
            return false;
        }
        if ('\u00f8' <= c && c <= '\u02ff') {
            return false;
        }
        if ('\u0370' <= c && c <= '\u037d') {
            return false;
        }
        if ('\u037f' <= c && c <= '\u1fff') {
            return false;
        }
        if ('\u200c' <= c && c <= '\u200d') {
            return false;
        }
        if ('\u2070' <= c && c <= '\u218f') {
            return false;
        }
        if ('\u2c00' <= c && c <= '\u2fef') {
            return false;
        }
        if ('\u3001' <= c && c <= '\ud7ff') {
            return false;
        }
        if ('\uf900' <= c && c <= '\ufdcf') {
            return false;
        }
        if ('\ufdf0' <= c && c <= '\ufffd') {
            return false;
        }
        if ('\u0300' <= c && c <= '\u036f') {
            return false;
        }
        return '\u203f' > c || c > '\u2040';
    }

    private static int parseHexString(String s) {
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            result <<= 4;
            char c = s.charAt(i);
            int digitValue = Character.digit(c, 16);
            if (digitValue < 0) {
                throw new NumberFormatException();
            }
            result += digitValue;
        }
        return result;
    }

    private static void checkAvailable(String s, int idx, int len) {
        if (s.length() < idx + len) {
            throw new IllegalArgumentException(MessageFormat.format("Expected {0} available chars in ''{1}'' string starting from {2} index", len, s, idx));
        }
    }

    private static char getNextChar(String s, int idx) {
        TreeConverterUtil.checkAvailable(s, idx, 1);
        return s.charAt(idx);
    }

    private static char readNextCharFromHexCode(String s, int idx, int len) {
        TreeConverterUtil.checkAvailable(s, idx, len);
        String numString = s.substring(idx, idx + len);
        try {
            int charValue = TreeConverterUtil.parseHexString(numString);
            return (char)charValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MessageFormat.format("Substring ''{0}'' of ''{1}'' string is not a valid hex number ", numString, s));
        }
    }

    public static String unescape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int startIdx = 0;
        while (startIdx >= 0) {
            int idx = s.indexOf(95, startIdx);
            if (idx >= 0) {
                sb.append(s.subSequence(startIdx, idx));
                char c = TreeConverterUtil.getNextChar(s, ++idx);
                switch (c) {
                    case '_': {
                        sb.append(c);
                        break;
                    }
                    case 'x': {
                        sb.append(TreeConverterUtil.readNextCharFromHexCode(s, ++idx, 2));
                        idx += 2;
                        break;
                    }
                    case 'u': {
                        sb.append(TreeConverterUtil.readNextCharFromHexCode(s, ++idx, 4));
                        idx += 4;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageFormat.format("Unexpected char ''{0}'' in ''{1}'' string located at index {2}", Character.valueOf(c), s, idx));
                    }
                }
            } else {
                sb.append(s.subSequence(startIdx, s.length()));
            }
            startIdx = ++idx;
        }
        return sb.toString();
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int start = 0;
        char[] cs = s.toCharArray();
        for (int idx = 0; idx < cs.length; ++idx) {
            char c = cs[idx];
            if (!TreeConverterUtil.shouldEscape(c)) continue;
            sb.append(cs, start, idx - start);
            sb.append('_');
            if (c == '_') {
                sb.append(c);
            } else {
                String asHex = Integer.toHexString(c);
                switch (asHex.length()) {
                    case 1: {
                        sb.append("x0");
                        break;
                    }
                    case 2: {
                        sb.append("x");
                        break;
                    }
                    case 3: {
                        sb.append("u0");
                        break;
                    }
                    case 4: {
                        sb.append("u");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                sb.append(asHex);
            }
            start = idx + 1;
        }
        if (start < s.length()) {
            sb.append(cs, start, s.length() - start);
        }
        return sb.toString();
    }

    private static final class SeparatorCharHolder {
        static final char SEPARATOR_CHAR = UINamingContainer.getSeparatorChar(FacesContext.getCurrentInstance());

        private SeparatorCharHolder() {
        }
    }
}

