/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert;

import com.google.common.base.Strings;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.richfaces.component.util.Strings;
import org.richfaces.convert.TreeConverterUtil;
import org.richfaces.model.DeclarativeModelKey;

public class DeclarativeModelKeyConverter
implements Converter {
    private Converter delegateConverter;

    public DeclarativeModelKeyConverter(Converter delegateConverter) {
        this.delegateConverter = delegateConverter;
    }

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (Strings.isNullOrEmpty(value)) {
            return null;
        }
        String s = TreeConverterUtil.unescape(value);
        Iterator<String> split = Strings.NamingContainerDataHolder.SEPARATOR_CHAR_SPLITTER.split(s).iterator();
        String modelId = split.next();
        Object modelKey = this.delegateConverter.getAsObject(context, component, split.next());
        if (split.hasNext()) {
            throw new ConverterException(value);
        }
        return new DeclarativeModelKey(modelId, modelKey);
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        DeclarativeModelKey declarativeModelKey = (DeclarativeModelKey)value;
        String convertedModelKey = this.delegateConverter.getAsString(context, component, declarativeModelKey.getModelKey());
        String keyString = Strings.NamingContainerDataHolder.SEPARATOR_CHAR_JOINER.join(declarativeModelKey.getModelId(), convertedModelKey);
        return TreeConverterUtil.escape(keyString);
    }
}

