/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.util;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.renderkit.util.HtmlDimensions;
import org.richfaces.renderkit.util.RendererUtils;

public final class HtmlUtil {
    public static final Pattern ID_SELECTOR_PATTERN = Pattern.compile("#((?:-[A-Za-z_-]|[A-Za-z_]|\\\\[^A-F0-9U]|\\\\[A-F0-9]{1,6}\\s?|\\\\U[0-9A-F]{2}(?:A[1-9A-F]|[B-F][0-9A-F]))(?:\\\\[A-F0-9]{1,6}\\s?|[A-Za-z0-9_-]|\\\\:)*)");
    private static final String ORG_AJAX4JSF = "org.ajax4jsf.";
    private static final String ORG_RICHFACES = "org.richfaces.";
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();

    private HtmlUtil() {
    }

    public static String addToSize(String declaration, String delta) {
        Double doubleDelta = HtmlDimensions.decode(delta);
        Double decoded = HtmlDimensions.decode(declaration);
        return HtmlDimensions.formatPx(new Double(decoded + doubleDelta));
    }

    private static String escapeReplacement(String s) {
        return s.replaceAll("(\\\\|\\$)", "\\\\$1");
    }

    public static String expandIdSelector(String selector, UIComponent component, FacesContext context) {
        Matcher matcher = ID_SELECTOR_PATTERN.matcher(selector);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String unescaped = matcher.group(1).replaceAll("\\\\:", ":");
            UIComponent target = RENDERER_UTILS.findComponentFor(component, unescaped);
            if (target == null) continue;
            matcher.appendReplacement(sb, HtmlUtil.escapeReplacement("#" + ScriptUtils.escapeCSSMetachars(target.getClientId(context))));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String idsToIdSelector(String ids) {
        StringBuffer buffer = new StringBuffer();
        if (ids != null) {
            String[] idString = ids.split("\\s*,\\s*");
            for (int i = 0; i < idString.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                idString[i] = idString[i].replaceAll(":", "\\\\:");
                buffer.append("#").append(idString[i]);
            }
        }
        return buffer.toString();
    }

    public static boolean shouldWriteId(UIComponent component) {
        String rendererType = component.getRendererType();
        String id = component.getId();
        if (id != null && !id.startsWith("j_id")) {
            return true;
        }
        return rendererType != null && (rendererType.startsWith(ORG_AJAX4JSF) || rendererType.startsWith(ORG_RICHFACES));
    }

    private static String concat(char separator, Object ... objects) {
        StringBuilder result = new StringBuilder();
        for (Object o : objects) {
            String s = (String)o;
            if (Strings.isNullOrEmpty(s)) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(s.trim());
        }
        return result.toString();
    }

    public static String concatClasses(Object ... classes) {
        return HtmlUtil.concat(' ', classes);
    }

    public static String concatStyles(Object ... styles) {
        return HtmlUtil.concat(';', styles);
    }

    public static String escapeHtml(String html) {
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#39;");
    }
}

